/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import org.apache.lucene.store.FilterDirectory;
import org.apache.lucene.store.c;
import org.apache.lucene.store.e;
import org.apache.lucene.store.g;
import org.apache.lucene.util.j;

public final class SleepingLockWrapper
extends FilterDirectory {
    public static long DEFAULT_POLL_INTERVAL = 1000L;
    private final long lockWaitTimeout;
    private final long pollInterval;

    public SleepingLockWrapper(c c2, long l2) {
        this(c2, l2, DEFAULT_POLL_INTERVAL);
    }

    public SleepingLockWrapper(c c2, long l2, long l3) {
        super(c2);
        this.lockWaitTimeout = l2;
        this.pollInterval = l3;
        if (l2 < 0L && l2 != -1L) {
            throw new IllegalArgumentException("lockWaitTimeout should be LOCK_OBTAIN_WAIT_FOREVER or a non-negative number (got " + l2 + ")");
        }
        if (l3 < 0L) {
            throw new IllegalArgumentException("pollInterval must be a non-negative number (got " + l3 + ")");
        }
    }

    @Override
    public final e obtainLock(String string) throws IOException {
        g g2 = null;
        long l2 = this.lockWaitTimeout / this.pollInterval;
        long l3 = 0L;
        while (true) {
            try {
                return this.in.obtainLock(string);
            }
            catch (g g3) {
                if (g2 == null) {
                    g2 = g3;
                }
                try {
                    Thread.sleep(this.pollInterval);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    throw new j(interruptedException);
                }
                if (l3++ < l2 || this.lockWaitTimeout == -1L) continue;
                String string2 = "Lock obtain timed out: " + this.toString();
                if (g2 != null) {
                    string2 = string2 + ": " + g2;
                }
                throw new g(string2, g2);
            }
            break;
        }
    }

    @Override
    public final String toString() {
        return "SleepingLockWrapper(" + this.in + ")";
    }
}

