/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.util.a;

public class RAMFile
implements a {
    protected final ArrayList<byte[]> buffers = new ArrayList();
    long length;
    RAMDirectory directory;
    protected long sizeInBytes;

    public RAMFile() {
    }

    RAMFile(RAMDirectory rAMDirectory) {
        this.directory = rAMDirectory;
    }

    public synchronized long getLength() {
        return this.length;
    }

    protected synchronized void setLength(long l2) {
        this.length = l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final byte[] addBuffer(int n2) {
        byte[] byArray = this.newBuffer(n2);
        RAMFile rAMFile = this;
        synchronized (rAMFile) {
            this.buffers.add(byArray);
            this.sizeInBytes += (long)n2;
        }
        if (this.directory != null) {
            this.directory.sizeInBytes.getAndAdd(n2);
        }
        return byArray;
    }

    protected final synchronized byte[] getBuffer(int n2) {
        return this.buffers.get(n2);
    }

    protected final synchronized int numBuffers() {
        return this.buffers.size();
    }

    protected byte[] newBuffer(int n2) {
        return new byte[n2];
    }

    @Override
    public synchronized long ramBytesUsed() {
        return this.sizeInBytes;
    }

    @Override
    public Collection<a> getChildResources() {
        return Collections.emptyList();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(length=" + this.length + ")";
    }

    public int hashCode() {
        int n2 = (int)(this.length ^ this.length >>> 32);
        for (byte[] byArray : this.buffers) {
            n2 = n2 * 31 + Arrays.hashCode(byArray);
        }
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (RAMFile)object;
        if (this.length != ((RAMFile)object).length) {
            return false;
        }
        if (this.buffers.size() != ((RAMFile)object).buffers.size()) {
            return false;
        }
        for (int i2 = 0; i2 < this.buffers.size(); ++i2) {
            if (Arrays.equals(this.buffers.get(i2), ((RAMFile)object).buffers.get(i2))) continue;
            return false;
        }
        return true;
    }
}

