/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.RAMFile;
import org.apache.lucene.store.RAMInputStream;
import org.apache.lucene.store.RAMOutputStream;
import org.apache.lucene.store.SingleInstanceLockFactory;
import org.apache.lucene.store.f;
import org.apache.lucene.util.a;
import org.apache.lucene.util.b;

public class RAMDirectory
extends BaseDirectory
implements a {
    protected final Map<String, RAMFile> fileMap = new ConcurrentHashMap<String, RAMFile>();
    protected final AtomicLong sizeInBytes = new AtomicLong();

    public RAMDirectory() {
        this(new SingleInstanceLockFactory());
    }

    public RAMDirectory(f f2) {
        super(f2);
    }

    @Override
    public final String[] listAll() {
        this.ensureOpen();
        Object object = this.fileMap.keySet();
        ArrayList<String> arrayList = new ArrayList<String>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            arrayList.add(string);
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public final long fileLength(String string) throws IOException {
        this.ensureOpen();
        RAMFile rAMFile = this.fileMap.get(string);
        if (rAMFile == null) {
            throw new FileNotFoundException(string);
        }
        return rAMFile.getLength();
    }

    @Override
    public final long ramBytesUsed() {
        this.ensureOpen();
        return this.sizeInBytes.get();
    }

    @Override
    public Collection<a> getChildResources() {
        return b.a("file", this.fileMap);
    }

    @Override
    public void deleteFile(String string) throws IOException {
        this.ensureOpen();
        RAMFile rAMFile = this.fileMap.remove(string);
        if (rAMFile != null) {
            rAMFile.directory = null;
            this.sizeInBytes.addAndGet(-rAMFile.sizeInBytes);
            return;
        }
        throw new FileNotFoundException(string);
    }

    @Override
    public IndexOutput createOutput(String string, IOContext object) throws IOException {
        this.ensureOpen();
        object = this.newRAMFile();
        RAMFile rAMFile = this.fileMap.remove(string);
        if (rAMFile != null) {
            this.sizeInBytes.addAndGet(-rAMFile.sizeInBytes);
            rAMFile.directory = null;
        }
        this.fileMap.put(string, (RAMFile)object);
        return new RAMOutputStream(string, (RAMFile)object, true);
    }

    protected RAMFile newRAMFile() {
        return new RAMFile(this);
    }

    @Override
    public void sync(Collection<String> collection) throws IOException {
    }

    @Override
    public void renameFile(String string, String string2) throws IOException {
        this.ensureOpen();
        RAMFile rAMFile = this.fileMap.get(string);
        if (rAMFile == null) {
            throw new FileNotFoundException(string);
        }
        this.fileMap.put(string2, rAMFile);
        this.fileMap.remove(string);
    }

    @Override
    public IndexInput openInput(String string, IOContext object) throws IOException {
        this.ensureOpen();
        object = this.fileMap.get(string);
        if (object == null) {
            throw new FileNotFoundException(string);
        }
        return new RAMInputStream(string, (RAMFile)object);
    }

    @Override
    public void close() {
        this.isOpen = false;
        this.fileMap.clear();
    }
}

