/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.zip.CRC32;
import java.util.zip.CheckedOutputStream;
import org.apache.lucene.store.IndexOutput;

public class OutputStreamIndexOutput
extends IndexOutput {
    private final CRC32 crc = new CRC32();
    private final BufferedOutputStream os;
    private long bytesWritten = 0L;
    private boolean flushedOnClose = false;

    public OutputStreamIndexOutput(String string, OutputStream outputStream, int n2) {
        super(string);
        this.os = new BufferedOutputStream(new CheckedOutputStream(outputStream, this.crc), n2);
    }

    @Override
    public final void writeByte(byte by) throws IOException {
        this.os.write(by);
        ++this.bytesWritten;
    }

    @Override
    public final void writeBytes(byte[] byArray, int n2, int n3) throws IOException {
        this.os.write(byArray, n2, n3);
        this.bytesWritten += (long)n3;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void close() throws IOException {
        BufferedOutputStream bufferedOutputStream = this.os;
        Throwable throwable = null;
        try {
            if (!this.flushedOnClose) {
                this.flushedOnClose = true;
                ((OutputStream)bufferedOutputStream).flush();
            }
            if (bufferedOutputStream == null) return;
        }
        catch (Throwable throwable2) {
            try {
                Throwable throwable3 = throwable2;
                throwable = throwable2;
                throw throwable3;
            }
            catch (Throwable throwable4) {
                if (bufferedOutputStream == null) throw throwable4;
                if (throwable != null) {
                    try {
                        ((OutputStream)bufferedOutputStream).close();
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        throwable.addSuppressed(throwable5);
                    }
                    throw throwable4;
                } else {
                    ((OutputStream)bufferedOutputStream).close();
                }
                throw throwable4;
            }
        }
        ((OutputStream)bufferedOutputStream).close();
        return;
    }

    @Override
    public final long getFilePointer() {
        return this.bytesWritten;
    }

    @Override
    public final long getChecksum() throws IOException {
        this.os.flush();
        return this.crc.getValue();
    }
}

