/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import org.apache.lucene.portmobile.file.Files;
import org.apache.lucene.portmobile.file.Path;
import org.apache.lucene.portmobile.file.StandardOpenOption;
import org.apache.lucene.portmobile.file.attribute.BasicFileAttributes;
import org.apache.lucene.portmobile.file.attribute.FileTime;
import org.apache.lucene.portmobile.util.FileChannelUtils;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.a;
import org.apache.lucene.store.d;
import org.apache.lucene.store.e;
import org.apache.lucene.store.g;
import org.apache.lucene.util.IOUtils;

public final class NativeFSLockFactory
extends d {
    public static final NativeFSLockFactory INSTANCE = new NativeFSLockFactory();
    private static final Set<String> LOCK_HELD = Collections.synchronizedSet(new HashSet());

    private NativeFSLockFactory() {
    }

    @Override
    protected final e obtainFSLock(FSDirectory object, String object2) throws IOException {
        object = ((FSDirectory)object).getDirectory();
        Files.createDirectories((Path)object);
        object = ((Path)object).resolve((String)object2);
        try {
            Files.createFile((Path)object);
        }
        catch (IOException iOException) {}
        object = ((Path)object).toRealPath();
        object2 = Files.readAttributes((Path)object, BasicFileAttributes.class).creationTime();
        if (LOCK_HELD.add(((Path)object).toString())) {
            block7: {
                block8: {
                    FileChannel fileChannel = null;
                    FileLock fileLock = null;
                    try {
                        fileChannel = FileChannelUtils.open((Path)object, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                        fileLock = fileChannel.tryLock();
                        if (fileLock == null) break block7;
                        object2 = new NativeFSLock(fileLock, fileChannel, (Path)object, (FileTime)object2);
                        if (fileLock != null) break block8;
                    }
                    catch (Throwable throwable) {
                        if (fileLock == null) {
                            IOUtils.closeWhileHandlingException(fileChannel);
                            NativeFSLockFactory.clearLockHeld((Path)object);
                        }
                        throw throwable;
                    }
                    IOUtils.closeWhileHandlingException(fileChannel);
                    NativeFSLockFactory.clearLockHeld((Path)object);
                }
                return object2;
            }
            throw new g("Lock held by another program: " + object);
        }
        throw new g("Lock held by this virtual machine: " + object);
    }

    private static final void clearLockHeld(Path path) throws IOException {
        if (!LOCK_HELD.remove(path.toString())) {
            throw new a("Lock path was cleared but never marked as held: " + path);
        }
    }

    static final class NativeFSLock
    extends e {
        final FileLock lock;
        final FileChannel channel;
        final Path path;
        final FileTime creationTime;
        volatile boolean closed;

        NativeFSLock(FileLock fileLock, FileChannel fileChannel, Path path, FileTime fileTime) {
            this.lock = fileLock;
            this.channel = fileChannel;
            this.path = path;
            this.creationTime = fileTime;
        }

        @Override
        public final void ensureValid() throws IOException {
            if (this.closed) {
                throw new a("Lock instance already released: " + this);
            }
            if (!LOCK_HELD.contains(this.path.toString())) {
                throw new a("Lock path unexpectedly cleared from map: " + this);
            }
            if (!this.lock.isValid()) {
                throw new a("FileLock invalidated by an external force: " + this);
            }
            long l2 = this.channel.size();
            if (l2 != 0L) {
                throw new a("Unexpected lock file size: " + l2 + ", (lock=" + this + ")");
            }
            FileTime fileTime = Files.readAttributes(this.path, BasicFileAttributes.class).creationTime();
            if (!this.creationTime.equals(fileTime)) {
                throw new a("Underlying file changed by an external force at " + this.creationTime + ", (lock=" + this + ")");
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        @Override
        public final synchronized void close() throws IOException {
            if (this.closed) {
                return;
            }
            try {
                FileChannel fileChannel = this.channel;
                Throwable throwable = null;
                try {
                    assert (this.lock != null);
                    assert (fileChannel != null);
                    this.lock.release();
                    if (fileChannel == null) return;
                }
                catch (Throwable throwable2) {
                    try {
                        Throwable throwable3 = throwable2;
                        throwable = throwable2;
                        throw throwable3;
                    }
                    catch (Throwable throwable4) {
                        if (fileChannel == null) throw throwable4;
                        if (throwable != null) {
                            try {
                                fileChannel.close();
                                throw throwable4;
                            }
                            catch (Throwable throwable5) {
                                throwable.addSuppressed(throwable5);
                            }
                            throw throwable4;
                        } else {
                            fileChannel.close();
                        }
                        throw throwable4;
                    }
                }
                fileChannel.close();
                return;
            }
            finally {
                this.closed = true;
                NativeFSLockFactory.clearLockHeld(this.path);
            }
        }

        public final String toString() {
            return "NativeFSLock(path=" + this.path + ",impl=" + this.lock + ",ctime=" + this.creationTime + ")";
        }
    }
}

