/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.EOFException;
import java.io.IOException;
import java.nio.Buffer;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import org.apache.lucene.portmobile.file.Path;
import org.apache.lucene.portmobile.file.StandardOpenOption;
import org.apache.lucene.portmobile.util.FileChannelUtils;
import org.apache.lucene.store.BufferedIndexInput;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.f;

public class NIOFSDirectory
extends FSDirectory {
    public NIOFSDirectory(Path path, f f2) throws IOException {
        super(path, f2);
    }

    @Override
    public IndexInput openInput(String object, IOContext iOContext) throws IOException {
        this.ensureOpen();
        object = this.getDirectory().resolve((String)object);
        FileChannel fileChannel = FileChannelUtils.open((Path)object, StandardOpenOption.READ);
        return new NIOFSIndexInput("NIOFSIndexInput(path=\"" + object + "\")", fileChannel, iOContext);
    }

    static final class NIOFSIndexInput
    extends BufferedIndexInput {
        protected final FileChannel channel;
        boolean isClone = false;
        protected final long off;
        protected final long end;
        private ByteBuffer byteBuf;

        public NIOFSIndexInput(String string, FileChannel fileChannel, IOContext iOContext) throws IOException {
            super(string, iOContext);
            this.channel = fileChannel;
            this.off = 0L;
            this.end = fileChannel.size();
        }

        public NIOFSIndexInput(String string, FileChannel fileChannel, long l2, long l3, int n2) {
            super(string, n2);
            this.channel = fileChannel;
            this.off = l2;
            this.end = l2 + l3;
            this.isClone = true;
        }

        @Override
        public final void close() throws IOException {
            if (!this.isClone) {
                this.channel.close();
            }
        }

        @Override
        public final NIOFSIndexInput clone() {
            NIOFSIndexInput nIOFSIndexInput = (NIOFSIndexInput)super.clone();
            ((NIOFSIndexInput)super.clone()).isClone = true;
            return nIOFSIndexInput;
        }

        @Override
        public final IndexInput slice(String string, long l2, long l3) throws IOException {
            if (l2 < 0L || l3 < 0L || l2 + l3 > this.length()) {
                throw new IllegalArgumentException("slice() " + string + " out of bounds: " + this);
            }
            return new NIOFSIndexInput(this.getFullSliceDescription(string), this.channel, this.off + l2, l3, this.getBufferSize());
        }

        @Override
        public final long length() {
            return this.end - this.off;
        }

        @Override
        protected final void newBuffer(byte[] byArray) {
            super.newBuffer(byArray);
            this.byteBuf = ByteBuffer.wrap(byArray);
        }

        @Override
        protected final void readInternal(byte[] object, int n2, int n3) throws IOException {
            if (object == this.buffer) {
                assert (this.byteBuf != null);
                object = this.byteBuf;
                this.byteBuf.clear().position(n2);
            } else {
                object = ByteBuffer.wrap((byte[])object, n2, n3);
            }
            long l2 = this.getFilePointer() + this.off;
            if (l2 + (long)n3 > this.end) {
                throw new EOFException("read past EOF: " + this);
            }
            try {
                int n4;
                int n5;
                for (n4 = n3; n4 > 0; n4 -= n5) {
                    int n6 = Math.min(16384, n4);
                    ((ByteBuffer)object).limit(((Buffer)object).position() + n6);
                    assert (((Buffer)object).remaining() == n6);
                    n5 = this.channel.read((ByteBuffer)object, l2);
                    if (n5 < 0) {
                        throw new EOFException("read past EOF: " + this + " off: " + n2 + " len: " + n3 + " pos: " + l2 + " chunkLen: " + n6 + " end: " + this.end);
                    }
                    assert (n5 > 0) : "FileChannel.read with non zero-length bb.remaining() must always read at least one byte (FileChannel is in blocking mode, see spec of ReadableByteChannel)";
                    l2 += (long)n5;
                }
                assert (n4 == 0);
                return;
            }
            catch (IOException iOException) {
                throw new IOException(iOException.getMessage() + ": " + this, iOException);
            }
        }

        @Override
        protected final void seekInternal(long l2) throws IOException {
        }
    }
}

