/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.ByteBuffer;
import java.nio.MappedByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.spi.AbstractInterruptibleChannel;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Locale;
import org.apache.lucene.portmobile.file.Path;
import org.apache.lucene.portmobile.file.StandardOpenOption;
import org.apache.lucene.portmobile.util.FileChannelUtils;
import org.apache.lucene.store.ByteBufferIndexInput;
import org.apache.lucene.store.FSDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexInput;
import org.apache.lucene.store.f;
import org.apache.lucene.util.Constants;

public class MMapDirectory
extends FSDirectory {
    private boolean useUnmapHack = UNMAP_SUPPORTED;
    private boolean preload;
    public static final int DEFAULT_MAX_CHUNK_SIZE = Constants.JRE_IS_64BIT ? 0x40000000 : 0x10000000;
    final int chunkSizePower;
    public static final boolean UNMAP_SUPPORTED = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

        private static Boolean a() {
            try {
                Class.forName("java.nio.DirectByteBuffer").getMethod("cleaner", new Class[0]).setAccessible(true);
                return true;
            }
            catch (Exception exception) {
                return false;
            }
        }

        @Override
        public final /* synthetic */ Object run() {
            return 1.a();
        }
    });
    private static final ByteBufferIndexInput.a CLEANER = new ByteBufferIndexInput.a(){

        @Override
        public final void a(ByteBufferIndexInput byteBufferIndexInput, final ByteBuffer byteBuffer) throws IOException {
            try {
                AccessController.doPrivileged(new PrivilegedExceptionAction<Void>(){

                    @Override
                    public Void run() throws Exception {
                        Object object = byteBuffer.getClass().getMethod("cleaner", new Class[0]);
                        ((Method)object).setAccessible(true);
                        object = ((Method)object).invoke((Object)byteBuffer, new Object[0]);
                        if (object != null) {
                            object.getClass().getMethod("clean", new Class[0]).invoke(object, new Object[0]);
                        }
                        return null;
                    }
                });
                return;
            }
            catch (PrivilegedActionException privilegedActionException) {
                throw new IOException("Unable to unmap the mapped buffer: " + byteBufferIndexInput.toString(), privilegedActionException.getCause());
            }
        }
    };

    public MMapDirectory(Path path, f f2) throws IOException {
        this(path, f2, DEFAULT_MAX_CHUNK_SIZE);
    }

    public MMapDirectory(Path path, f f2, int n2) throws IOException {
        super(path, f2);
        if (n2 <= 0) {
            throw new IllegalArgumentException("Maximum chunk size for mmap must be >0");
        }
        this.chunkSizePower = 31 - Integer.numberOfLeadingZeros(n2);
        assert (this.chunkSizePower >= 0 && this.chunkSizePower <= 30);
    }

    public boolean getUseUnmap() {
        return this.useUnmapHack;
    }

    @Override
    public IndexInput openInput(String object, IOContext object2) throws IOException {
        block9: {
            this.ensureOpen();
            object = this.directory.resolve((String)object);
            object2 = FileChannelUtils.open((Path)object, StandardOpenOption.READ);
            Throwable throwable = null;
            try {
                object = "MMapIndexInput(path=\"" + ((Path)object).toString() + "\")";
                boolean bl = this.getUseUnmap();
                object = ByteBufferIndexInput.newInstance((String)object, this.map((String)object, (FileChannel)object2, 0L, ((FileChannel)object2).size()), ((FileChannel)object2).size(), this.chunkSizePower, bl ? CLEANER : null, bl);
                if (object2 == null) break block9;
            }
            catch (Throwable throwable2) {
                try {
                    object = throwable2;
                    throwable = throwable2;
                    throw object;
                }
                catch (Throwable throwable3) {
                    if (object2 != null) {
                        if (throwable != null) {
                            try {
                                ((AbstractInterruptibleChannel)object2).close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            ((AbstractInterruptibleChannel)object2).close();
                        }
                    }
                    throw throwable3;
                }
            }
            ((AbstractInterruptibleChannel)object2).close();
        }
        return object;
    }

    final ByteBuffer[] map(String string, FileChannel fileChannel, long l2, long l3) throws IOException {
        if (l3 >>> this.chunkSizePower >= Integer.MAX_VALUE) {
            throw new IllegalArgumentException("RandomAccessFile too big for chunk size: " + string);
        }
        long l4 = 1L << this.chunkSizePower;
        int n2 = (int)(l3 >>> this.chunkSizePower) + 1;
        ByteBuffer[] byteBufferArray = new ByteBuffer[n2];
        long l5 = 0L;
        for (int i2 = 0; i2 < n2; ++i2) {
            MappedByteBuffer mappedByteBuffer;
            int n3 = (int)(l3 > l5 + l4 ? l4 : l3 - l5);
            try {
                mappedByteBuffer = fileChannel.map(FileChannel.MapMode.READ_ONLY, l2 + l5, n3);
            }
            catch (IOException iOException) {
                throw this.convertMapFailedIOException(iOException, string, n3);
            }
            if (this.preload) {
                mappedByteBuffer.load();
            }
            byteBufferArray[i2] = mappedByteBuffer;
            l5 += (long)n3;
        }
        return byteBufferArray;
    }

    private IOException convertMapFailedIOException(IOException iOException, String object, int n2) {
        Throwable throwable;
        String string;
        if (iOException.getCause() instanceof OutOfMemoryError) {
            string = "Map failed";
            throwable = null;
        } else {
            string = iOException.getMessage();
            throwable = iOException.getCause();
        }
        String string2 = !Constants.JRE_IS_64BIT ? "MMapDirectory should only be used on 64bit platforms, because the address space on 32bit operating systems is too small. " : (Constants.WINDOWS ? "Windows is unfortunately very limited on virtual address space. If your index size is several hundred Gigabytes, consider changing to Linux. " : (Constants.LINUX ? "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'), and 'sysctl vm.max_map_count'. " : "Please review 'ulimit -v', 'ulimit -m' (both should return 'unlimited'). "));
        object = new IOException(String.format(Locale.ENGLISH, "%s: %s [this may be caused by lack of enough unfragmented virtual address space or too restrictive virtual memory limits enforced by the operating system, preventing us to map a chunk of %d bytes. %sMore information: http://blog.thetaphi.de/2012/07/use-lucenes-mmapdirectory-on-64bit.html]", string, object, n2, string2), throwable);
        ((Throwable)object).setStackTrace(iOException.getStackTrace());
        return object;
    }
}

