/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import org.apache.lucene.portmobile.file.Files;
import org.apache.lucene.portmobile.file.Path;
import org.apache.lucene.portmobile.file.StandardCopyOption;
import org.apache.lucene.store.BaseDirectory;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.IndexOutput;
import org.apache.lucene.store.MMapDirectory;
import org.apache.lucene.store.NIOFSDirectory;
import org.apache.lucene.store.OutputStreamIndexOutput;
import org.apache.lucene.store.SimpleFSDirectory;
import org.apache.lucene.store.d;
import org.apache.lucene.store.f;
import org.apache.lucene.util.Constants;
import org.apache.lucene.util.IOUtils;

public abstract class FSDirectory
extends BaseDirectory {
    protected final Path directory;

    protected FSDirectory(Path path, f f2) throws IOException {
        super(f2);
        if (!Files.isDirectory(path)) {
            Files.createDirectories(path);
        }
        this.directory = path.toRealPath();
    }

    public static FSDirectory open(Path path) throws IOException {
        return FSDirectory.open(path, d.getDefault());
    }

    public static FSDirectory open(Path path, f f2) throws IOException {
        if (Constants.JRE_IS_64BIT && MMapDirectory.UNMAP_SUPPORTED) {
            return new MMapDirectory(path, f2);
        }
        if (Constants.WINDOWS) {
            return new SimpleFSDirectory(path, f2);
        }
        return new NIOFSDirectory(path, f2);
    }

    public static String[] listAll(Path object) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            for (Path path : Files.newDirectoryStream((Path)object)) {
                arrayList.add(path.getFileName().toString());
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return arrayList.toArray(new String[arrayList.size()]);
    }

    @Override
    public String[] listAll() throws IOException {
        this.ensureOpen();
        return FSDirectory.listAll(this.directory);
    }

    @Override
    public long fileLength(String string) throws IOException {
        this.ensureOpen();
        return Files.size(this.directory.resolve(string));
    }

    @Override
    public void deleteFile(String string) throws IOException {
        this.ensureOpen();
        Files.delete(this.directory.resolve(string));
    }

    @Override
    public IndexOutput createOutput(String string, IOContext iOContext) throws IOException {
        this.ensureOpen();
        this.ensureCanWrite(string);
        return new FSIndexOutput(string);
    }

    protected void ensureCanWrite(String string) throws IOException {
        Files.deleteIfExists(this.directory.resolve(string));
    }

    @Override
    public void sync(Collection<String> object) throws IOException {
        this.ensureOpen();
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            this.fsync(string);
        }
    }

    @Override
    public void renameFile(String string, String string2) throws IOException {
        this.ensureOpen();
        Files.move(this.directory.resolve(string), this.directory.resolve(string2), StandardCopyOption.ATOMIC_MOVE);
        IOUtils.fsync(this.directory, true);
    }

    @Override
    public synchronized void close() {
        this.isOpen = false;
    }

    public Path getDirectory() {
        this.ensureOpen();
        return this.directory;
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "@" + this.directory + " lockFactory=" + this.lockFactory;
    }

    protected void fsync(String string) throws IOException {
        IOUtils.fsync(this.directory.resolve(string), false);
    }

    final class FSIndexOutput
    extends OutputStreamIndexOutput {
        public FSIndexOutput(String string) throws IOException {
            super("FSIndexOutput(path=\"" + FSDirectory.this.directory.resolve(string) + "\")", new FilterOutputStream(Files.newOutputStream(FSDirectory.this.directory.resolve(string))){

                @Override
                public void write(byte[] byArray, int n2, int n3) throws IOException {
                    while (n3 > 0) {
                        int n4 = Math.min(n3, 8192);
                        this.out.write(byArray, n2, n4);
                        n3 -= n4;
                        n2 += n4;
                    }
                }
            }, 8192);
        }
    }
}

