/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.Map;
import java.util.Set;
import org.apache.lucene.store.DataInput;
import org.apache.lucene.util.BitUtil;
import org.apache.lucene.util.BytesRef;

public abstract class DataOutput {
    private static int COPY_BUFFER_SIZE = 16384;
    private byte[] copyBuffer;

    public abstract void writeByte(byte var1) throws IOException;

    public void writeBytes(byte[] byArray, int n2) throws IOException {
        this.writeBytes(byArray, 0, n2);
    }

    public abstract void writeBytes(byte[] var1, int var2, int var3) throws IOException;

    public void writeInt(int n2) throws IOException {
        this.writeByte(n2 >> 24);
        this.writeByte((byte)(n2 >> 16));
        this.writeByte((byte)(n2 >> 8));
        this.writeByte((byte)n2);
    }

    public void writeShort(short s2) throws IOException {
        this.writeByte((byte)(s2 >> 8));
        this.writeByte((byte)s2);
    }

    public final void writeVInt(int n2) throws IOException {
        while ((n2 & 0xFFFFFF80) != 0) {
            this.writeByte((byte)(n2 & 0x7F | 0x80));
            n2 >>>= 7;
        }
        this.writeByte((byte)n2);
    }

    public final void writeZInt(int n2) throws IOException {
        this.writeVInt(BitUtil.zigZagEncode(n2));
    }

    public void writeLong(long l2) throws IOException {
        this.writeInt((int)(l2 >> 32));
        this.writeInt((int)l2);
    }

    public final void writeVLong(long l2) throws IOException {
        if (l2 < 0L) {
            throw new IllegalArgumentException("cannot write negative vLong (got: " + l2 + ")");
        }
        this.writeSignedVLong(l2);
    }

    private void writeSignedVLong(long l2) throws IOException {
        while ((l2 & 0xFFFFFFFFFFFFFF80L) != 0L) {
            this.writeByte((byte)(l2 & 0x7FL | 0x80L));
            l2 >>>= 7;
        }
        this.writeByte((byte)l2);
    }

    public final void writeZLong(long l2) throws IOException {
        this.writeSignedVLong(BitUtil.zigZagEncode(l2));
    }

    public void writeString(String object) throws IOException {
        object = new BytesRef((CharSequence)object);
        this.writeVInt(((BytesRef)object).length);
        this.writeBytes(((BytesRef)object).bytes, ((BytesRef)object).offset, ((BytesRef)object).length);
    }

    public void copyBytes(DataInput dataInput, long l2) throws IOException {
        assert (l2 >= 0L) : "numBytes=" + l2;
        long l3 = l2;
        if (this.copyBuffer == null) {
            this.copyBuffer = new byte[COPY_BUFFER_SIZE];
        }
        while (l3 > 0L) {
            int n2 = l3 > (long)COPY_BUFFER_SIZE ? COPY_BUFFER_SIZE : (int)l3;
            dataInput.readBytes(this.copyBuffer, 0, n2);
            this.writeBytes(this.copyBuffer, 0, n2);
            l3 -= (long)n2;
        }
    }

    public void writeMapOfStrings(Map<String, String> object) throws IOException {
        this.writeVInt(object.size());
        for (Map.Entry entry : object.entrySet()) {
            this.writeString((String)entry.getKey());
            this.writeString((String)entry.getValue());
        }
    }

    public void writeSetOfStrings(Set<String> object) throws IOException {
        this.writeVInt(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            String string = (String)object.next();
            this.writeString(string);
        }
    }
}

