/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.store;

import java.io.IOException;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.lucene.portmobile.charset.StandardCharsets;
import org.apache.lucene.util.BitUtil;

public abstract class DataInput
implements Cloneable {
    private byte[] skipBuffer;

    public abstract byte readByte() throws IOException;

    public abstract void readBytes(byte[] var1, int var2, int var3) throws IOException;

    public void readBytes(byte[] byArray, int n2, int n3, boolean bl) throws IOException {
        this.readBytes(byArray, n2, n3);
    }

    public short readShort() throws IOException {
        return (short)((this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF);
    }

    public int readInt() throws IOException {
        return (this.readByte() & 0xFF) << 24 | (this.readByte() & 0xFF) << 16 | (this.readByte() & 0xFF) << 8 | this.readByte() & 0xFF;
    }

    public int readVInt() throws IOException {
        byte by = this.readByte();
        if (by >= 0) {
            return by;
        }
        int n2 = by & 0x7F;
        by = this.readByte();
        n2 |= (by & 0x7F) << 7;
        if (by >= 0) {
            return n2;
        }
        by = this.readByte();
        n2 |= (by & 0x7F) << 14;
        if (by >= 0) {
            return n2;
        }
        by = this.readByte();
        n2 |= (by & 0x7F) << 21;
        if (by >= 0) {
            return n2;
        }
        by = this.readByte();
        n2 |= (by & 0xF) << 28;
        if ((by & 0xF0) == 0) {
            return n2;
        }
        throw new IOException("Invalid vInt detected (too many bits)");
    }

    public int readZInt() throws IOException {
        return BitUtil.zigZagDecode(this.readVInt());
    }

    public long readLong() throws IOException {
        return (long)this.readInt() << 32 | (long)this.readInt() & 0xFFFFFFFFL;
    }

    public long readVLong() throws IOException {
        return this.readVLong(false);
    }

    private long readVLong(boolean bl) throws IOException {
        byte by = this.readByte();
        if (by >= 0) {
            return by;
        }
        long l2 = (long)by & 0x7FL;
        by = this.readByte();
        l2 |= ((long)by & 0x7FL) << 7;
        if (by >= 0) {
            return l2;
        }
        by = this.readByte();
        l2 |= ((long)by & 0x7FL) << 14;
        if (by >= 0) {
            return l2;
        }
        by = this.readByte();
        l2 |= ((long)by & 0x7FL) << 21;
        if (by >= 0) {
            return l2;
        }
        by = this.readByte();
        l2 |= ((long)by & 0x7FL) << 28;
        if (by >= 0) {
            return l2;
        }
        by = this.readByte();
        l2 |= ((long)by & 0x7FL) << 35;
        if (by >= 0) {
            return l2;
        }
        by = this.readByte();
        l2 |= ((long)by & 0x7FL) << 42;
        if (by >= 0) {
            return l2;
        }
        by = this.readByte();
        l2 |= ((long)by & 0x7FL) << 49;
        if (by >= 0) {
            return l2;
        }
        by = this.readByte();
        l2 |= ((long)by & 0x7FL) << 56;
        if (by >= 0) {
            return l2;
        }
        if (bl) {
            by = this.readByte();
            l2 |= ((long)by & 0x7FL) << 63;
            if (by == 0 || by == 1) {
                return l2;
            }
            throw new IOException("Invalid vLong detected (more than 64 bits)");
        }
        throw new IOException("Invalid vLong detected (negative values disallowed)");
    }

    public long readZLong() throws IOException {
        return BitUtil.zigZagDecode(this.readVLong(true));
    }

    public String readString() throws IOException {
        int n2 = this.readVInt();
        byte[] byArray = new byte[n2];
        this.readBytes(byArray, 0, n2);
        return new String(byArray, 0, n2, StandardCharsets.UTF_8);
    }

    public DataInput clone() {
        try {
            return (DataInput)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new Error("This cannot happen: Failing to clone DataInput");
        }
    }

    @Deprecated
    public Map<String, String> readStringStringMap() throws IOException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        int n2 = this.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.readString();
            String string2 = this.readString();
            hashMap.put(string, string2);
        }
        return hashMap;
    }

    public Map<String, String> readMapOfStrings() throws IOException {
        int n2 = this.readVInt();
        if (n2 == 0) {
            return Collections.emptyMap();
        }
        if (n2 == 1) {
            return Collections.singletonMap(this.readString(), this.readString());
        }
        AbstractMap abstractMap = n2 > 10 ? new HashMap() : new TreeMap();
        for (int i2 = 0; i2 < n2; ++i2) {
            String string = this.readString();
            String string2 = this.readString();
            abstractMap.put(string, string2);
        }
        return Collections.unmodifiableMap(abstractMap);
    }

    @Deprecated
    public Set<String> readStringSet() throws IOException {
        HashSet<String> hashSet = new HashSet<String>();
        int n2 = this.readInt();
        for (int i2 = 0; i2 < n2; ++i2) {
            hashSet.add(this.readString());
        }
        return hashSet;
    }

    public Set<String> readSetOfStrings() throws IOException {
        int n2 = this.readVInt();
        if (n2 == 0) {
            return Collections.emptySet();
        }
        if (n2 == 1) {
            return Collections.singleton(this.readString());
        }
        AbstractSet abstractSet = n2 > 10 ? new HashSet() : new TreeSet();
        for (int i2 = 0; i2 < n2; ++i2) {
            abstractSet.add(this.readString());
        }
        return Collections.unmodifiableSet(abstractSet);
    }

    public void skipBytes(long l2) throws IOException {
        int n2;
        if (l2 < 0L) {
            throw new IllegalArgumentException("numBytes must be >= 0, got " + l2);
        }
        if (this.skipBuffer == null) {
            this.skipBuffer = new byte[1024];
        }
        assert (this.skipBuffer.length == 1024);
        for (long i2 = 0L; i2 < l2; i2 += (long)n2) {
            n2 = (int)Math.min(1024L, l2 - i2);
            this.readBytes(this.skipBuffer, 0, n2, false);
        }
    }
}

