/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.term;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.AbstractSecondPassGroupingCollector;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.SentinelIntSet;

public class TermSecondPassGroupingCollector
extends AbstractSecondPassGroupingCollector<BytesRef> {
    private final SentinelIntSet ordSet;
    private SortedDocValues index;
    private final String groupField;

    public TermSecondPassGroupingCollector(String string, Collection<SearchGroup<BytesRef>> collection, Sort sort, Sort sort2, int n2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        super(collection, sort, sort2, n2, bl, bl2, bl3);
        this.ordSet = new SentinelIntSet(this.groupMap.size(), -2);
        this.groupField = string;
        this.groupDocs = new AbstractSecondPassGroupingCollector.SearchGroupDocs[this.ordSet.keys.length];
    }

    @Override
    protected void doSetNextReader(LeafReaderContext object) throws IOException {
        super.doSetNextReader((LeafReaderContext)object);
        this.index = DocValues.getSorted(((LeafReaderContext)object).reader(), this.groupField);
        this.ordSet.clear();
        for (AbstractSecondPassGroupingCollector.SearchGroupDocs searchGroupDocs : this.groupMap.values()) {
            int n2;
            int n3 = n2 = searchGroupDocs.groupValue == null ? -1 : this.index.lookupTerm((BytesRef)searchGroupDocs.groupValue);
            if (searchGroupDocs.groupValue != null && n2 < 0) continue;
            this.groupDocs[this.ordSet.put((int)n2)] = searchGroupDocs;
        }
    }

    @Override
    protected AbstractSecondPassGroupingCollector.SearchGroupDocs<BytesRef> retrieveGroup(int n2) throws IOException {
        if ((n2 = this.ordSet.find(this.index.getOrd(n2))) >= 0) {
            return this.groupDocs[n2];
        }
        return null;
    }

    @Override
    public boolean needsScores() {
        return true;
    }
}

