/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.term;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.lucene.index.DocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.grouping.AbstractAllGroupHeadsCollector;
import org.apache.lucene.search.h;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.SentinelIntSet;

public abstract class TermAllGroupHeadsCollector<GH extends AbstractAllGroupHeadsCollector.GroupHead<?>>
extends AbstractAllGroupHeadsCollector<GH> {
    final String groupField;
    SortedDocValues groupIndex;
    LeafReaderContext readerContext;

    protected TermAllGroupHeadsCollector(String string, int n2) {
        super(n2);
        this.groupField = string;
    }

    public static AbstractAllGroupHeadsCollector<?> create(String string, Sort sort, int n2) {
        boolean bl = true;
        boolean bl2 = true;
        for (SortField sortField : sort.getSort()) {
            if (sortField.getType() == SortField.Type.SCORE) {
                bl2 = false;
                continue;
            }
            if (TermAllGroupHeadsCollector.needGeneralImpl(sortField)) {
                return new GeneralAllGroupHeadsCollector(string, sort);
            }
            bl = false;
        }
        if (bl) {
            return new ScoreAllGroupHeadsCollector(string, sort, n2);
        }
        if (bl2) {
            return new OrdAllGroupHeadsCollector(string, sort, n2);
        }
        return new OrdScoreAllGroupHeadsCollector(string, sort, n2);
    }

    private static boolean needGeneralImpl(SortField object) {
        return (object = object.getType()) != SortField.Type.STRING_VAL && object != SortField.Type.STRING && object != SortField.Type.SCORE;
    }

    @Override
    public boolean needsScores() {
        return true;
    }

    static class ScoreAllGroupHeadsCollector
    extends TermAllGroupHeadsCollector<GroupHead> {
        private final SentinelIntSet ordSet;
        private final List<GroupHead> collectedGroups;
        private final SortField[] fields;
        private Scorer scorer;
        private GroupHead[] segmentGroupHeads;

        ScoreAllGroupHeadsCollector(String sortFieldArray, Sort sort, int n2) {
            super((String)sortFieldArray, sort.getSort().length);
            this.ordSet = new SentinelIntSet(n2, -2);
            this.collectedGroups = new ArrayList<GroupHead>(n2);
            sortFieldArray = sort.getSort();
            this.fields = new SortField[sortFieldArray.length];
            for (int i2 = 0; i2 < sortFieldArray.length; ++i2) {
                this.reversed[i2] = sortFieldArray[i2].getReverse() ? -1 : 1;
                this.fields[i2] = sortFieldArray[i2];
            }
        }

        @Override
        protected Collection<GroupHead> getCollectedGroupHeads() {
            return this.collectedGroups;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        protected void retrieveGroupHeadAndAddIfNotExist(int n2) throws IOException {
            GroupHead groupHead;
            int n3 = this.groupIndex.getOrd(n2);
            if (!this.ordSet.exists(n3)) {
                this.ordSet.put(n3);
                BytesRef bytesRef = n3 == -1 ? null : BytesRef.deepCopyOf(this.groupIndex.lookupOrd(n3));
                groupHead = new GroupHead(n2, bytesRef);
                this.collectedGroups.add(groupHead);
                this.segmentGroupHeads[n3 + 1] = groupHead;
                this.temporalResult.stop = true;
            } else {
                this.temporalResult.stop = false;
                groupHead = this.segmentGroupHeads[n3 + 1];
            }
            this.temporalResult.groupHead = groupHead;
        }

        @Override
        protected void doSetNextReader(LeafReaderContext object) throws IOException {
            this.readerContext = object;
            this.groupIndex = DocValues.getSorted(((LeafReaderContext)object).reader(), this.groupField);
            this.ordSet.clear();
            this.segmentGroupHeads = new GroupHead[this.groupIndex.getValueCount() + 1];
            for (GroupHead groupHead : this.collectedGroups) {
                int n2 = groupHead.groupValue == null ? -1 : this.groupIndex.lookupTerm((BytesRef)groupHead.groupValue);
                if (groupHead.groupValue != null && n2 < 0) continue;
                this.ordSet.put(n2);
                this.segmentGroupHeads[n2 + 1] = groupHead;
            }
        }

        class GroupHead
        extends AbstractAllGroupHeadsCollector.GroupHead<BytesRef> {
            float[] scores;

            private GroupHead(int n2, BytesRef bytesRef) throws IOException {
                super(bytesRef, n2 + ScoreAllGroupHeadsCollector.this.readerContext.docBase);
                this.scores = new float[ScoreAllGroupHeadsCollector.this.fields.length];
                float f2 = ScoreAllGroupHeadsCollector.this.scorer.score();
                for (n2 = 0; n2 < this.scores.length; ++n2) {
                    this.scores[n2] = f2;
                }
            }

            @Override
            public int compare(int n2, int n3) throws IOException {
                float f2 = ScoreAllGroupHeadsCollector.this.scorer.score();
                if (this.scores[n2] < f2) {
                    return 1;
                }
                if (this.scores[n2] > f2) {
                    return -1;
                }
                return 0;
            }

            @Override
            public void updateDocHead(int n2) throws IOException {
                float f2 = ScoreAllGroupHeadsCollector.this.scorer.score();
                for (int i2 = 0; i2 < this.scores.length; ++i2) {
                    this.scores[i2] = f2;
                }
                this.doc = n2 + ScoreAllGroupHeadsCollector.this.readerContext.docBase;
            }
        }
    }

    static class OrdAllGroupHeadsCollector
    extends TermAllGroupHeadsCollector<GroupHead> {
        private final SentinelIntSet ordSet;
        private final List<GroupHead> collectedGroups;
        private final SortField[] fields;
        private SortedDocValues[] sortsIndex;
        private GroupHead[] segmentGroupHeads;

        OrdAllGroupHeadsCollector(String sortFieldArray, Sort sort, int n2) {
            super((String)sortFieldArray, sort.getSort().length);
            this.ordSet = new SentinelIntSet(n2, -2);
            this.collectedGroups = new ArrayList<GroupHead>(n2);
            sortFieldArray = sort.getSort();
            this.fields = new SortField[sortFieldArray.length];
            this.sortsIndex = new SortedDocValues[sortFieldArray.length];
            for (int i2 = 0; i2 < sortFieldArray.length; ++i2) {
                this.reversed[i2] = sortFieldArray[i2].getReverse() ? -1 : 1;
                this.fields[i2] = sortFieldArray[i2];
            }
        }

        @Override
        protected Collection<GroupHead> getCollectedGroupHeads() {
            return this.collectedGroups;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
        }

        @Override
        protected void retrieveGroupHeadAndAddIfNotExist(int n2) throws IOException {
            GroupHead groupHead;
            int n3 = this.groupIndex.getOrd(n2);
            if (!this.ordSet.exists(n3)) {
                this.ordSet.put(n3);
                BytesRef bytesRef = n3 == -1 ? null : BytesRef.deepCopyOf(this.groupIndex.lookupOrd(n3));
                groupHead = new GroupHead(n2, bytesRef);
                this.collectedGroups.add(groupHead);
                this.segmentGroupHeads[n3 + 1] = groupHead;
                this.temporalResult.stop = true;
            } else {
                this.temporalResult.stop = false;
                groupHead = this.segmentGroupHeads[n3 + 1];
            }
            this.temporalResult.groupHead = groupHead;
        }

        @Override
        protected void doSetNextReader(LeafReaderContext object2) throws IOException {
            this.readerContext = object2;
            this.groupIndex = DocValues.getSorted(((LeafReaderContext)object2).reader(), this.groupField);
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                this.sortsIndex[i2] = DocValues.getSorted(((LeafReaderContext)object2).reader(), this.fields[i2].getField());
            }
            this.ordSet.clear();
            this.segmentGroupHeads = new GroupHead[this.groupIndex.getValueCount() + 1];
            for (GroupHead groupHead : this.collectedGroups) {
                int n2 = groupHead.groupValue == null ? -1 : this.groupIndex.lookupTerm((BytesRef)groupHead.groupValue);
                if (groupHead.groupValue != null && n2 < 0) continue;
                this.ordSet.put(n2);
                this.segmentGroupHeads[n2 + 1] = groupHead;
                for (n2 = 0; n2 < this.sortsIndex.length; ++n2) {
                    int n3 = groupHead.sortOrds[n2] == -1 ? -1 : this.sortsIndex[n2].lookupTerm(groupHead.sortValues[n2].get());
                    groupHead.sortOrds[n2] = n3;
                }
            }
        }

        class GroupHead
        extends AbstractAllGroupHeadsCollector.GroupHead<BytesRef> {
            BytesRefBuilder[] sortValues;
            int[] sortOrds;

            private GroupHead(int n2, BytesRef bytesRef) {
                super(bytesRef, n2 + OrdAllGroupHeadsCollector.this.readerContext.docBase);
                this.sortValues = new BytesRefBuilder[OrdAllGroupHeadsCollector.this.sortsIndex.length];
                this.sortOrds = new int[OrdAllGroupHeadsCollector.this.sortsIndex.length];
                for (int i2 = 0; i2 < OrdAllGroupHeadsCollector.this.sortsIndex.length; ++i2) {
                    this.sortOrds[i2] = OrdAllGroupHeadsCollector.this.sortsIndex[i2].getOrd(n2);
                    this.sortValues[i2] = new BytesRefBuilder();
                    this.sortValues[i2].copyBytes(OrdAllGroupHeadsCollector.this.sortsIndex[i2].get(n2));
                }
            }

            @Override
            public int compare(int n2, int n3) throws IOException {
                if (this.sortOrds[n2] < 0) {
                    BytesRef bytesRef = OrdAllGroupHeadsCollector.this.sortsIndex[n2].get(n3);
                    return this.sortValues[n2].get().compareTo(bytesRef);
                }
                return this.sortOrds[n2] - OrdAllGroupHeadsCollector.this.sortsIndex[n2].getOrd(n3);
            }

            @Override
            public void updateDocHead(int n2) throws IOException {
                for (int i2 = 0; i2 < OrdAllGroupHeadsCollector.this.sortsIndex.length; ++i2) {
                    this.sortOrds[i2] = OrdAllGroupHeadsCollector.this.sortsIndex[i2].getOrd(n2);
                    this.sortValues[i2].copyBytes(OrdAllGroupHeadsCollector.this.sortsIndex[i2].get(n2));
                }
                this.doc = n2 + OrdAllGroupHeadsCollector.this.readerContext.docBase;
            }
        }
    }

    static class OrdScoreAllGroupHeadsCollector
    extends TermAllGroupHeadsCollector<GroupHead> {
        private final SentinelIntSet ordSet;
        private final List<GroupHead> collectedGroups;
        private final SortField[] fields;
        private SortedDocValues[] sortsIndex;
        private Scorer scorer;
        private GroupHead[] segmentGroupHeads;

        OrdScoreAllGroupHeadsCollector(String sortFieldArray, Sort sort, int n2) {
            super((String)sortFieldArray, sort.getSort().length);
            this.ordSet = new SentinelIntSet(n2, -2);
            this.collectedGroups = new ArrayList<GroupHead>(n2);
            sortFieldArray = sort.getSort();
            this.fields = new SortField[sortFieldArray.length];
            this.sortsIndex = new SortedDocValues[sortFieldArray.length];
            for (int i2 = 0; i2 < sortFieldArray.length; ++i2) {
                this.reversed[i2] = sortFieldArray[i2].getReverse() ? -1 : 1;
                this.fields[i2] = sortFieldArray[i2];
            }
        }

        @Override
        protected Collection<GroupHead> getCollectedGroupHeads() {
            return this.collectedGroups;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }

        @Override
        protected void retrieveGroupHeadAndAddIfNotExist(int n2) throws IOException {
            GroupHead groupHead;
            int n3 = this.groupIndex.getOrd(n2);
            if (!this.ordSet.exists(n3)) {
                this.ordSet.put(n3);
                BytesRef bytesRef = n3 == -1 ? null : BytesRef.deepCopyOf(this.groupIndex.lookupOrd(n3));
                groupHead = new GroupHead(n2, bytesRef);
                this.collectedGroups.add(groupHead);
                this.segmentGroupHeads[n3 + 1] = groupHead;
                this.temporalResult.stop = true;
            } else {
                this.temporalResult.stop = false;
                groupHead = this.segmentGroupHeads[n3 + 1];
            }
            this.temporalResult.groupHead = groupHead;
        }

        @Override
        protected void doSetNextReader(LeafReaderContext object2) throws IOException {
            this.readerContext = object2;
            this.groupIndex = DocValues.getSorted(((LeafReaderContext)object2).reader(), this.groupField);
            for (int i2 = 0; i2 < this.fields.length; ++i2) {
                if (this.fields[i2].getType() == SortField.Type.SCORE) continue;
                this.sortsIndex[i2] = DocValues.getSorted(((LeafReaderContext)object2).reader(), this.fields[i2].getField());
            }
            this.ordSet.clear();
            this.segmentGroupHeads = new GroupHead[this.groupIndex.getValueCount() + 1];
            for (GroupHead groupHead : this.collectedGroups) {
                int n2 = groupHead.groupValue == null ? -1 : this.groupIndex.lookupTerm((BytesRef)groupHead.groupValue);
                if (groupHead.groupValue != null && n2 < 0) continue;
                this.ordSet.put(n2);
                this.segmentGroupHeads[n2 + 1] = groupHead;
                for (n2 = 0; n2 < this.sortsIndex.length; ++n2) {
                    if (this.fields[n2].getType() == SortField.Type.SCORE) continue;
                    int n3 = groupHead.sortValues[n2] == null ? -1 : this.sortsIndex[n2].lookupTerm(groupHead.sortValues[n2].get());
                    groupHead.sortOrds[n2] = n3;
                }
            }
        }

        class GroupHead
        extends AbstractAllGroupHeadsCollector.GroupHead<BytesRef> {
            BytesRefBuilder[] sortValues;
            int[] sortOrds;
            float[] scores;

            private GroupHead(int n2, BytesRef bytesRef) throws IOException {
                super(bytesRef, n2 + OrdScoreAllGroupHeadsCollector.this.readerContext.docBase);
                this.sortValues = new BytesRefBuilder[OrdScoreAllGroupHeadsCollector.this.sortsIndex.length];
                this.sortOrds = new int[OrdScoreAllGroupHeadsCollector.this.sortsIndex.length];
                this.scores = new float[OrdScoreAllGroupHeadsCollector.this.sortsIndex.length];
                for (int i2 = 0; i2 < OrdScoreAllGroupHeadsCollector.this.sortsIndex.length; ++i2) {
                    if (OrdScoreAllGroupHeadsCollector.this.fields[i2].getType() == SortField.Type.SCORE) {
                        this.scores[i2] = OrdScoreAllGroupHeadsCollector.this.scorer.score();
                        continue;
                    }
                    this.sortOrds[i2] = OrdScoreAllGroupHeadsCollector.this.sortsIndex[i2].getOrd(n2);
                    this.sortValues[i2] = new BytesRefBuilder();
                    if (this.sortOrds[i2] == -1) continue;
                    this.sortValues[i2].copyBytes(OrdScoreAllGroupHeadsCollector.this.sortsIndex[i2].get(n2));
                }
            }

            @Override
            public int compare(int n2, int n3) throws IOException {
                if (OrdScoreAllGroupHeadsCollector.this.fields[n2].getType() == SortField.Type.SCORE) {
                    float f2 = OrdScoreAllGroupHeadsCollector.this.scorer.score();
                    if (this.scores[n2] < f2) {
                        return 1;
                    }
                    if (this.scores[n2] > f2) {
                        return -1;
                    }
                    return 0;
                }
                if (this.sortOrds[n2] < 0) {
                    BytesRef bytesRef = OrdScoreAllGroupHeadsCollector.this.sortsIndex[n2].get(n3);
                    return this.sortValues[n2].get().compareTo(bytesRef);
                }
                return this.sortOrds[n2] - OrdScoreAllGroupHeadsCollector.this.sortsIndex[n2].getOrd(n3);
            }

            @Override
            public void updateDocHead(int n2) throws IOException {
                for (int i2 = 0; i2 < OrdScoreAllGroupHeadsCollector.this.sortsIndex.length; ++i2) {
                    if (OrdScoreAllGroupHeadsCollector.this.fields[i2].getType() == SortField.Type.SCORE) {
                        this.scores[i2] = OrdScoreAllGroupHeadsCollector.this.scorer.score();
                        continue;
                    }
                    this.sortOrds[i2] = OrdScoreAllGroupHeadsCollector.this.sortsIndex[i2].getOrd(n2);
                    this.sortValues[i2].copyBytes(OrdScoreAllGroupHeadsCollector.this.sortsIndex[i2].get(n2));
                }
                this.doc = n2 + OrdScoreAllGroupHeadsCollector.this.readerContext.docBase;
            }
        }
    }

    static class GeneralAllGroupHeadsCollector
    extends TermAllGroupHeadsCollector<GroupHead> {
        private final Sort sortWithinGroup;
        private final Map<BytesRef, GroupHead> groups;
        private Scorer scorer;

        GeneralAllGroupHeadsCollector(String sortFieldArray, Sort sort) {
            super((String)sortFieldArray, sort.getSort().length);
            this.sortWithinGroup = sort;
            this.groups = new HashMap<BytesRef, GroupHead>();
            sortFieldArray = sort.getSort();
            for (int i2 = 0; i2 < sortFieldArray.length; ++i2) {
                this.reversed[i2] = sortFieldArray[i2].getReverse() ? -1 : 1;
            }
        }

        @Override
        protected void retrieveGroupHeadAndAddIfNotExist(int n2) throws IOException {
            int n3 = this.groupIndex.getOrd(n2);
            BytesRef bytesRef = n3 == -1 ? null : this.groupIndex.lookupOrd(n3);
            GroupHead groupHead = this.groups.get(bytesRef);
            if (groupHead == null) {
                bytesRef = bytesRef == null ? null : BytesRef.deepCopyOf(bytesRef);
                groupHead = new GroupHead(bytesRef, this.sortWithinGroup, n2);
                this.groups.put(bytesRef, groupHead);
                this.temporalResult.stop = true;
            } else {
                this.temporalResult.stop = false;
            }
            this.temporalResult.groupHead = groupHead;
        }

        @Override
        protected Collection<GroupHead> getCollectedGroupHeads() {
            return this.groups.values();
        }

        @Override
        protected void doSetNextReader(LeafReaderContext leafReaderContext) throws IOException {
            this.readerContext = leafReaderContext;
            this.groupIndex = DocValues.getSorted(leafReaderContext.reader(), this.groupField);
            for (GroupHead groupHead : this.groups.values()) {
                for (int i2 = 0; i2 < groupHead.comparators.length; ++i2) {
                    groupHead.leafComparators[i2] = groupHead.comparators[i2].getLeafComparator(leafReaderContext);
                }
            }
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            Iterator<GroupHead> iterator = this.groups.values().iterator();
            while (iterator.hasNext()) {
                h[] hArray = iterator.next().leafComparators;
                int n2 = iterator.next().leafComparators.length;
                for (int i2 = 0; i2 < n2; ++i2) {
                    hArray[i2].setScorer(scorer);
                }
            }
        }

        class GroupHead
        extends AbstractAllGroupHeadsCollector.GroupHead<BytesRef> {
            final FieldComparator[] comparators;
            final h[] leafComparators;

            private GroupHead(BytesRef sortFieldArray, Sort sort, int n2) throws IOException {
                super(sortFieldArray, n2 + GeneralAllGroupHeadsCollector.this.readerContext.docBase);
                sortFieldArray = sort.getSort();
                this.comparators = new FieldComparator[sortFieldArray.length];
                this.leafComparators = new h[sortFieldArray.length];
                for (int i2 = 0; i2 < sortFieldArray.length; ++i2) {
                    this.comparators[i2] = sortFieldArray[i2].getComparator(1, i2);
                    this.leafComparators[i2] = this.comparators[i2].getLeafComparator(GeneralAllGroupHeadsCollector.this.readerContext);
                    this.leafComparators[i2].setScorer(GeneralAllGroupHeadsCollector.this.scorer);
                    this.leafComparators[i2].copy(0, n2);
                    this.leafComparators[i2].setBottom(0);
                }
            }

            @Override
            public int compare(int n2, int n3) throws IOException {
                return this.leafComparators[n2].compareBottom(n3);
            }

            @Override
            public void updateDocHead(int n2) throws IOException {
                h[] hArray = this.leafComparators;
                int n3 = this.leafComparators.length;
                for (int i2 = 0; i2 < n3; ++i2) {
                    h h2 = hArray[i2];
                    h2.copy(0, n2);
                    h2.setBottom(0);
                }
                this.doc = n2 + GeneralAllGroupHeadsCollector.this.readerContext.docBase;
            }
        }
    }
}

