/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping.function;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.a;
import org.apache.lucene.queries.function.b;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.grouping.AbstractAllGroupHeadsCollector;
import org.apache.lucene.search.h;
import org.apache.lucene.util.mutable.MutableValue;

public class FunctionAllGroupHeadsCollector
extends AbstractAllGroupHeadsCollector<GroupHead> {
    private final b groupBy;
    private final Map<?, ?> vsContext;
    private final Map<MutableValue, GroupHead> groups = new HashMap<MutableValue, GroupHead>();
    private final Sort sortWithinGroup;
    private a.a filler;
    private MutableValue mval;
    private LeafReaderContext readerContext;
    private Scorer scorer;

    public FunctionAllGroupHeadsCollector(b sortFieldArray, Map<?, ?> map, Sort sort) {
        super(sort.getSort().length);
        this.sortWithinGroup = sort;
        this.groupBy = sortFieldArray;
        this.vsContext = map;
        sortFieldArray = sort.getSort();
        for (int i2 = 0; i2 < sortFieldArray.length; ++i2) {
            this.reversed[i2] = sortFieldArray[i2].getReverse() ? -1 : 1;
        }
    }

    @Override
    protected void retrieveGroupHeadAndAddIfNotExist(int n2) throws IOException {
        this.filler.fillValue(n2);
        GroupHead groupHead = this.groups.get(this.mval);
        if (groupHead == null) {
            MutableValue mutableValue = this.mval.duplicate();
            groupHead = new GroupHead(mutableValue, this.sortWithinGroup, n2);
            this.groups.put(mutableValue, groupHead);
            this.temporalResult.stop = true;
        } else {
            this.temporalResult.stop = false;
        }
        this.temporalResult.groupHead = groupHead;
    }

    @Override
    protected Collection<GroupHead> getCollectedGroupHeads() {
        return this.groups.values();
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
        Iterator<GroupHead> iterator = this.groups.values().iterator();
        while (iterator.hasNext()) {
            h[] hArray = iterator.next().leafComparators;
            int n2 = iterator.next().leafComparators.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                hArray[i2].setScorer(scorer);
            }
        }
    }

    @Override
    protected void doSetNextReader(LeafReaderContext leafReaderContext) throws IOException {
        this.readerContext = leafReaderContext;
        a a2 = this.groupBy.a();
        this.filler = a2.a();
        this.mval = this.filler.getValue();
        for (GroupHead groupHead : this.groups.values()) {
            for (int i2 = 0; i2 < groupHead.comparators.length; ++i2) {
                groupHead.leafComparators[i2] = groupHead.comparators[i2].getLeafComparator(leafReaderContext);
            }
        }
    }

    @Override
    public boolean needsScores() {
        return true;
    }

    public class GroupHead
    extends AbstractAllGroupHeadsCollector.GroupHead<MutableValue> {
        final FieldComparator<?>[] comparators;
        final h[] leafComparators;

        private GroupHead(MutableValue sortFieldArray, Sort sort, int n2) throws IOException {
            super(sortFieldArray, n2 + ((FunctionAllGroupHeadsCollector)FunctionAllGroupHeadsCollector.this).readerContext.docBase);
            sortFieldArray = sort.getSort();
            this.comparators = new FieldComparator[sortFieldArray.length];
            this.leafComparators = new h[sortFieldArray.length];
            for (int i2 = 0; i2 < sortFieldArray.length; ++i2) {
                this.comparators[i2] = sortFieldArray[i2].getComparator(1, i2);
                this.leafComparators[i2] = this.comparators[i2].getLeafComparator(FunctionAllGroupHeadsCollector.this.readerContext);
                this.leafComparators[i2].setScorer(FunctionAllGroupHeadsCollector.this.scorer);
                this.leafComparators[i2].copy(0, n2);
                this.leafComparators[i2].setBottom(0);
            }
        }

        @Override
        public int compare(int n2, int n3) throws IOException {
            return this.leafComparators[n2].compareBottom(n3);
        }

        @Override
        public void updateDocHead(int n2) throws IOException {
            h[] hArray = this.leafComparators;
            int n3 = this.leafComparators.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                h h2 = hArray[i2];
                h2.copy(0, n2);
                h2.setBottom(0);
            }
            this.doc = n2 + ((FunctionAllGroupHeadsCollector)FunctionAllGroupHeadsCollector.this).readerContext.docBase;
        }
    }
}

