/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.queries.function.b;
import org.apache.lucene.search.CachingCollector;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiCollector;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.c;
import org.apache.lucene.search.grouping.AbstractFirstPassGroupingCollector;
import org.apache.lucene.search.grouping.AbstractSecondPassGroupingCollector;
import org.apache.lucene.search.grouping.BlockGroupingCollector;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.search.grouping.a;
import org.apache.lucene.search.grouping.function.FunctionAllGroupHeadsCollector;
import org.apache.lucene.search.grouping.function.FunctionAllGroupsCollector;
import org.apache.lucene.search.grouping.function.FunctionFirstPassGroupingCollector;
import org.apache.lucene.search.grouping.function.FunctionSecondPassGroupingCollector;
import org.apache.lucene.search.grouping.term.TermAllGroupHeadsCollector;
import org.apache.lucene.search.grouping.term.TermAllGroupsCollector;
import org.apache.lucene.search.grouping.term.TermFirstPassGroupingCollector;
import org.apache.lucene.search.grouping.term.TermSecondPassGroupingCollector;
import org.apache.lucene.search.o;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.mutable.MutableValue;

public class GroupingSearch {
    private final String groupField;
    private final b groupFunction;
    private final Map<?, ?> valueSourceContext;
    private final Query groupEndDocs;
    private Sort groupSort = Sort.RELEVANCE;
    private Sort sortWithinGroup;
    private int groupDocsOffset;
    private int groupDocsLimit = 1;
    private boolean fillSortFields;
    private boolean includeScores = true;
    private boolean includeMaxScore = true;
    private Double maxCacheRAMMB;
    private Integer maxDocsToCache;
    private boolean cacheScores;
    private boolean allGroups;
    private boolean allGroupHeads;
    private int initialSize = 128;
    private Collection<?> matchingGroups;
    private Bits matchingGroupHeads;

    public GroupingSearch(String string) {
        this(string, null, null, null);
    }

    private GroupingSearch(String string, b b2, Map<?, ?> map, Query query) {
        this.groupField = string;
        this.groupFunction = b2;
        this.valueSourceContext = map;
        this.groupEndDocs = query;
    }

    public <T> TopGroups<T> search(IndexSearcher indexSearcher, Query query, int n2, int n3) throws IOException {
        if (this.groupField != null || this.groupFunction != null) {
            return this.groupByFieldOrFunction(indexSearcher, query, n2, n3);
        }
        if (this.groupEndDocs != null) {
            return this.groupByDocBlock(indexSearcher, query, n2, n3);
        }
        throw new IllegalStateException("Either groupField, groupFunction or groupEndDocs must be set.");
    }

    protected TopGroups groupByFieldOrFunction(IndexSearcher indexSearcher, Query query, int n2, int n3) throws IOException {
        c c2;
        Object object;
        FunctionAllGroupHeadsCollector functionAllGroupHeadsCollector;
        a a2;
        AbstractFirstPassGroupingCollector abstractFirstPassGroupingCollector;
        n3 = n2 + n3;
        if (this.groupFunction != null) {
            abstractFirstPassGroupingCollector = new FunctionFirstPassGroupingCollector(this.groupFunction, this.valueSourceContext, this.groupSort, n3);
            a2 = this.allGroups ? new FunctionAllGroupsCollector(this.groupFunction, this.valueSourceContext) : null;
            functionAllGroupHeadsCollector = this.allGroupHeads ? new FunctionAllGroupHeadsCollector(this.groupFunction, this.valueSourceContext, this.sortWithinGroup) : null;
        } else {
            abstractFirstPassGroupingCollector = new TermFirstPassGroupingCollector(this.groupField, this.groupSort, n3);
            a2 = this.allGroups ? new TermAllGroupsCollector(this.groupField, this.initialSize) : null;
            functionAllGroupHeadsCollector = this.allGroupHeads ? TermAllGroupHeadsCollector.create(this.groupField, this.sortWithinGroup, this.initialSize) : null;
        }
        if (this.allGroupHeads || this.allGroups) {
            object = new ArrayList<o>();
            object.add(abstractFirstPassGroupingCollector);
            if (this.allGroups) {
                object.add(a2);
            }
            if (this.allGroupHeads) {
                object.add(functionAllGroupHeadsCollector);
            }
            c2 = MultiCollector.wrap(object.toArray(new c[object.size()]));
        } else {
            c2 = abstractFirstPassGroupingCollector;
        }
        object = null;
        if (this.maxCacheRAMMB != null || this.maxDocsToCache != null) {
            object = this.maxCacheRAMMB != null ? CachingCollector.create(c2, this.cacheScores, this.maxCacheRAMMB) : CachingCollector.create(c2, this.cacheScores, this.maxDocsToCache);
            indexSearcher.search(query, (c)object);
        } else {
            indexSearcher.search(query, c2);
        }
        this.matchingGroups = this.allGroups ? a2.getGroups() : Collections.emptyList();
        this.matchingGroupHeads = this.allGroupHeads ? functionAllGroupHeadsCollector.retrieveGroupHeads(indexSearcher.getIndexReader().maxDoc()) : new Bits.MatchNoBits(indexSearcher.getIndexReader().maxDoc());
        Object object2 = abstractFirstPassGroupingCollector.getTopGroups(n2, this.fillSortFields);
        if (object2 == null) {
            return new TopGroups(new SortField[0], new SortField[0], 0, 0, new GroupDocs[0], Float.NaN);
        }
        int n4 = this.groupDocsOffset + this.groupDocsLimit;
        object2 = this.groupFunction != null ? new FunctionSecondPassGroupingCollector((Collection<SearchGroup<MutableValue>>)object2, this.groupSort, this.sortWithinGroup, n4, this.includeScores, this.includeMaxScore, this.fillSortFields, this.groupFunction, this.valueSourceContext) : new TermSecondPassGroupingCollector(this.groupField, (Collection<SearchGroup<BytesRef>>)object2, this.groupSort, this.sortWithinGroup, n4, this.includeScores, this.includeMaxScore, this.fillSortFields);
        if (object != null && ((CachingCollector)object).isCached()) {
            ((CachingCollector)object).replay((c)object2);
        } else {
            indexSearcher.search(query, (c)object2);
        }
        if (this.allGroups) {
            return new TopGroups(((AbstractSecondPassGroupingCollector)object2).getTopGroups(this.groupDocsOffset), this.matchingGroups.size());
        }
        return ((AbstractSecondPassGroupingCollector)object2).getTopGroups(this.groupDocsOffset);
    }

    protected TopGroups<?> groupByDocBlock(IndexSearcher indexSearcher, Query query, int n2, int n3) throws IOException {
        n3 = n2 + n3;
        Weight weight = indexSearcher.createNormalizedWeight(this.groupEndDocs, false);
        BlockGroupingCollector blockGroupingCollector = new BlockGroupingCollector(this.groupSort, n3, this.includeScores, weight);
        indexSearcher.search(query, blockGroupingCollector);
        int n4 = this.groupDocsOffset + this.groupDocsLimit;
        return blockGroupingCollector.getTopGroups(this.sortWithinGroup, n2, this.groupDocsOffset, n4, this.fillSortFields);
    }

    public GroupingSearch setCachingInMB(double d2, boolean bl) {
        this.maxCacheRAMMB = d2;
        this.maxDocsToCache = null;
        this.cacheScores = bl;
        return this;
    }

    public GroupingSearch setGroupSort(Sort sort) {
        this.groupSort = sort;
        return this;
    }

    public GroupingSearch setSortWithinGroup(Sort sort) {
        this.sortWithinGroup = sort;
        return this;
    }

    public GroupingSearch setGroupDocsLimit(int n2) {
        this.groupDocsLimit = n2;
        return this;
    }

    public GroupingSearch setFillSortFields(boolean bl) {
        this.fillSortFields = bl;
        return this;
    }

    public GroupingSearch setIncludeScores(boolean bl) {
        this.includeScores = bl;
        return this;
    }

    public GroupingSearch setIncludeMaxScore(boolean bl) {
        this.includeMaxScore = bl;
        return this;
    }
}

