/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.g;
import org.apache.lucene.search.grouping.FakeScorer;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.search.h;
import org.apache.lucene.search.o;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.PriorityQueue;

public class BlockGroupingCollector
extends o {
    private int[] pendingSubDocs;
    private float[] pendingSubScores;
    private int subDocUpto;
    private final Sort groupSort;
    private final int topNGroups;
    private final Weight lastDocPerGroup;
    private final boolean needsScores;
    private final FieldComparator<?>[] comparators;
    private final h[] leafComparators;
    private final int[] reversed;
    private final int compIDXEnd;
    private int bottomSlot;
    private boolean queueFull;
    private LeafReaderContext currentReaderContext;
    private int topGroupDoc;
    private int totalHitCount;
    private int totalGroupCount;
    private int docBase;
    private int groupEndDocID;
    private DocIdSetIterator lastDocPerGroupBits;
    private Scorer scorer;
    private final GroupQueue groupQueue;
    private boolean groupCompetes;

    private void processGroup() {
        ++this.totalGroupCount;
        if (this.groupCompetes) {
            if (!this.queueFull) {
                OneGroup oneGroup = new OneGroup();
                new OneGroup().count = this.subDocUpto;
                oneGroup.topGroupDoc = this.docBase + this.topGroupDoc;
                oneGroup.docs = this.pendingSubDocs;
                this.pendingSubDocs = new int[10];
                if (this.needsScores) {
                    oneGroup.scores = this.pendingSubScores;
                    this.pendingSubScores = new float[10];
                }
                oneGroup.readerContext = this.currentReaderContext;
                oneGroup.comparatorSlot = this.bottomSlot;
                OneGroup oneGroup2 = this.groupQueue.add(oneGroup);
                boolean bl = this.queueFull = this.groupQueue.size() == this.topNGroups;
                if (this.queueFull) {
                    this.bottomSlot = oneGroup2.comparatorSlot;
                    for (int i2 = 0; i2 < this.comparators.length; ++i2) {
                        this.leafComparators[i2].setBottom(this.bottomSlot);
                    }
                } else {
                    this.bottomSlot = this.groupQueue.size();
                }
            } else {
                OneGroup oneGroup = (OneGroup)this.groupQueue.top();
                assert (oneGroup != null);
                oneGroup.count = this.subDocUpto;
                oneGroup.topGroupDoc = this.docBase + this.topGroupDoc;
                Object[] objectArray = oneGroup.docs;
                oneGroup.docs = this.pendingSubDocs;
                this.pendingSubDocs = objectArray;
                if (this.needsScores) {
                    objectArray = oneGroup.scores;
                    oneGroup.scores = this.pendingSubScores;
                    this.pendingSubScores = objectArray;
                }
                oneGroup.readerContext = this.currentReaderContext;
                this.bottomSlot = ((OneGroup)this.groupQueue.updateTop()).comparatorSlot;
                for (int i3 = 0; i3 < this.comparators.length; ++i3) {
                    this.leafComparators[i3].setBottom(this.bottomSlot);
                }
            }
        }
        this.subDocUpto = 0;
    }

    public BlockGroupingCollector(Sort sortFieldArray, int n2, boolean n3, Weight object) throws IOException {
        if (n2 <= 0) {
            throw new IllegalArgumentException("topNGroups must be >= 1 (got " + n2 + ")");
        }
        this.groupQueue = new GroupQueue(n2);
        this.pendingSubDocs = new int[10];
        if (n3 != 0) {
            this.pendingSubScores = new float[10];
        }
        this.needsScores = n3;
        this.lastDocPerGroup = object;
        this.groupSort = sortFieldArray;
        this.topNGroups = n2;
        sortFieldArray = sortFieldArray.getSort();
        this.comparators = new FieldComparator[sortFieldArray.length];
        this.leafComparators = new h[sortFieldArray.length];
        this.compIDXEnd = this.comparators.length - 1;
        this.reversed = new int[sortFieldArray.length];
        for (n3 = 0; n3 < sortFieldArray.length; ++n3) {
            object = sortFieldArray[n3];
            this.comparators[n3] = ((SortField)object).getComparator(n2, n3);
            this.reversed[n3] = ((SortField)object).getReverse() ? -1 : 1;
        }
    }

    public TopGroups<?> getTopGroups(Sort sort, int n2, int n3, int n4, boolean bl) throws IOException {
        if (this.subDocUpto != 0) {
            this.processGroup();
        }
        if (n2 >= this.groupQueue.size()) {
            return null;
        }
        int n5 = 0;
        FakeScorer fakeScorer = new FakeScorer();
        float f2 = Float.MIN_VALUE;
        GroupDocs[] groupDocsArray = new GroupDocs[this.groupQueue.size() - n2];
        for (n2 = this.groupQueue.size() - n2 - 1; n2 >= 0; --n2) {
            Object[] objectArray;
            int n6;
            TopDocsCollector topDocsCollector;
            OneGroup oneGroup = (OneGroup)this.groupQueue.pop();
            if (sort == null) {
                if (!this.needsScores) {
                    throw new IllegalArgumentException("cannot sort by relevance within group: needsScores=false");
                }
                topDocsCollector = TopScoreDocCollector.create(n4);
            } else {
                topDocsCollector = TopFieldCollector.create(sort, n4, bl, this.needsScores, this.needsScores);
            }
            g g2 = topDocsCollector.getLeafCollector(oneGroup.readerContext);
            g2.setScorer(fakeScorer);
            for (int i2 = 0; i2 < oneGroup.count; ++i2) {
                fakeScorer.doc = n6 = oneGroup.docs[i2];
                if (this.needsScores) {
                    fakeScorer.score = oneGroup.scores[i2];
                }
                g2.collect(n6);
            }
            n5 += oneGroup.count;
            if (bl) {
                objectArray = new Comparable[this.comparators.length];
                for (n6 = 0; n6 < this.comparators.length; ++n6) {
                    objectArray[n6] = this.comparators[n6].value(oneGroup.comparatorSlot);
                }
            } else {
                objectArray = null;
            }
            TopDocs topDocs = topDocsCollector.topDocs(n3, n4);
            groupDocsArray[n2] = new GroupDocs<Object>(Float.NaN, topDocs.getMaxScore(), oneGroup.count, topDocs.scoreDocs, null, objectArray);
            f2 = Math.max(f2, topDocs.getMaxScore());
        }
        return new TopGroups(new TopGroups(this.groupSort.getSort(), sort == null ? null : sort.getSort(), this.totalHitCount, n5, groupDocsArray, f2), this.totalGroupCount);
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        this.scorer = scorer;
        h[] hArray = this.leafComparators;
        int n2 = this.leafComparators.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            hArray[i2].setScorer(scorer);
        }
    }

    @Override
    public void collect(int n2) throws IOException {
        int n3;
        if (n2 > this.groupEndDocID) {
            if (this.subDocUpto != 0) {
                this.processGroup();
            }
            this.groupEndDocID = this.lastDocPerGroupBits.advance(n2);
            this.subDocUpto = 0;
            this.groupCompetes = !this.queueFull;
        }
        ++this.totalHitCount;
        if (this.subDocUpto == this.pendingSubDocs.length) {
            this.pendingSubDocs = ArrayUtil.grow(this.pendingSubDocs);
        }
        this.pendingSubDocs[this.subDocUpto] = n2;
        if (this.needsScores) {
            if (this.subDocUpto == this.pendingSubScores.length) {
                this.pendingSubScores = ArrayUtil.grow(this.pendingSubScores);
            }
            this.pendingSubScores[this.subDocUpto] = this.scorer.score();
        }
        ++this.subDocUpto;
        if (this.groupCompetes) {
            int n4;
            if (this.subDocUpto == 1) {
                assert (!this.queueFull);
                h[] hArray = this.leafComparators;
                int n5 = this.leafComparators.length;
                for (int i2 = 0; i2 < n5; ++i2) {
                    h h2 = hArray[i2];
                    h2.copy(this.bottomSlot, n2);
                    h2.setBottom(this.bottomSlot);
                }
                this.topGroupDoc = n2;
                return;
            }
            int n6 = 0;
            while (true) {
                if ((n4 = this.reversed[n6] * this.leafComparators[n6].compareBottom(n2)) < 0) {
                    return;
                }
                if (n4 > 0) break;
                if (n6 == this.compIDXEnd) {
                    return;
                }
                ++n6;
            }
            h[] hArray = this.leafComparators;
            n4 = this.leafComparators.length;
            for (int i3 = 0; i3 < n4; ++i3) {
                h h3 = hArray[i3];
                h3.copy(this.bottomSlot, n2);
                h3.setBottom(this.bottomSlot);
            }
            this.topGroupDoc = n2;
            return;
        }
        int n7 = 0;
        while (true) {
            if ((n3 = this.reversed[n7] * this.leafComparators[n7].compareBottom(n2)) < 0) {
                return;
            }
            if (n3 > 0) break;
            if (n7 == this.compIDXEnd) {
                return;
            }
            ++n7;
        }
        this.groupCompetes = true;
        h[] hArray = this.leafComparators;
        n3 = this.leafComparators.length;
        for (int i4 = 0; i4 < n3; ++i4) {
            h h4 = hArray[i4];
            h4.copy(this.bottomSlot, n2);
            h4.setBottom(this.bottomSlot);
        }
        this.topGroupDoc = n2;
    }

    @Override
    protected void doSetNextReader(LeafReaderContext leafReaderContext) throws IOException {
        if (this.subDocUpto != 0) {
            this.processGroup();
        }
        this.subDocUpto = 0;
        this.docBase = leafReaderContext.docBase;
        this.lastDocPerGroupBits = this.lastDocPerGroup.scorer(leafReaderContext);
        this.groupEndDocID = -1;
        this.currentReaderContext = leafReaderContext;
        for (int i2 = 0; i2 < this.comparators.length; ++i2) {
            this.leafComparators[i2] = this.comparators[i2].getLeafComparator(leafReaderContext);
        }
    }

    @Override
    public boolean needsScores() {
        return this.needsScores;
    }

    private final class GroupQueue
    extends PriorityQueue<OneGroup> {
        public GroupQueue(int n2) {
            super(n2);
        }

        @Override
        protected final boolean lessThan(OneGroup oneGroup, OneGroup oneGroup2) {
            assert (oneGroup != oneGroup2);
            assert (oneGroup.comparatorSlot != oneGroup2.comparatorSlot);
            int n2 = BlockGroupingCollector.this.comparators.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = BlockGroupingCollector.this.reversed[i2] * BlockGroupingCollector.this.comparators[i2].compare(oneGroup.comparatorSlot, oneGroup2.comparatorSlot);
                if (n3 == 0) continue;
                return n3 > 0;
            }
            return oneGroup.topGroupDoc > oneGroup2.topGroupDoc;
        }
    }

    private static final class OneGroup {
        LeafReaderContext readerContext;
        int topGroupDoc;
        int[] docs;
        float[] scores;
        int count;
        int comparatorSlot;

        private OneGroup() {
        }
    }
}

