/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.g;
import org.apache.lucene.search.grouping.GroupDocs;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.grouping.TopGroups;
import org.apache.lucene.search.o;

public abstract class AbstractSecondPassGroupingCollector<GROUP_VALUE_TYPE>
extends o {
    protected final Map<GROUP_VALUE_TYPE, SearchGroupDocs<GROUP_VALUE_TYPE>> groupMap;
    private final int maxDocsPerGroup;
    protected SearchGroupDocs<GROUP_VALUE_TYPE>[] groupDocs;
    private final Collection<SearchGroup<GROUP_VALUE_TYPE>> groups;
    private final Sort withinGroupSort;
    private final Sort groupSort;
    private int totalHitCount;
    private int totalGroupedHitCount;

    public AbstractSecondPassGroupingCollector(Collection<SearchGroup<GROUP_VALUE_TYPE>> object, Sort object2, Sort sort, int n2, boolean bl, boolean bl2, boolean bl3) throws IOException {
        if (object.size() == 0) {
            throw new IllegalArgumentException("no groups to collect (groups.size() is 0)");
        }
        this.groupSort = object2;
        this.withinGroupSort = sort;
        this.groups = object;
        this.maxDocsPerGroup = n2;
        this.groupMap = new HashMap<GROUP_VALUE_TYPE, SearchGroupDocs<GROUP_VALUE_TYPE>>(object.size());
        object = object.iterator();
        while (object.hasNext()) {
            object2 = (SearchGroup)object.next();
            TopDocsCollector topDocsCollector = sort == null ? TopScoreDocCollector.create(n2) : TopFieldCollector.create(sort, n2, bl3, bl, bl2);
            this.groupMap.put(((SearchGroup)object2).groupValue, new SearchGroupDocs(((SearchGroup)object2).groupValue, topDocsCollector));
        }
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        Iterator<SearchGroupDocs<GROUP_VALUE_TYPE>> iterator = this.groupMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().leafCollector.setScorer(scorer);
        }
    }

    @Override
    public void collect(int n2) throws IOException {
        ++this.totalHitCount;
        SearchGroupDocs<GROUP_VALUE_TYPE> searchGroupDocs = this.retrieveGroup(n2);
        if (searchGroupDocs != null) {
            ++this.totalGroupedHitCount;
            searchGroupDocs.leafCollector.collect(n2);
        }
    }

    protected abstract SearchGroupDocs<GROUP_VALUE_TYPE> retrieveGroup(int var1) throws IOException;

    @Override
    protected void doSetNextReader(LeafReaderContext leafReaderContext) throws IOException {
        Iterator<SearchGroupDocs<GROUP_VALUE_TYPE>> iterator = this.groupMap.values().iterator();
        while (iterator.hasNext()) {
            iterator.next().leafCollector = iterator.next().collector.getLeafCollector(leafReaderContext);
        }
    }

    public TopGroups<GROUP_VALUE_TYPE> getTopGroups(int n2) {
        GroupDocs[] groupDocsArray = new GroupDocs[this.groups.size()];
        int n3 = 0;
        float f2 = Float.MIN_VALUE;
        for (SearchGroup<GROUP_VALUE_TYPE> searchGroup : this.groups) {
            SearchGroupDocs<GROUP_VALUE_TYPE> searchGroupDocs = this.groupMap.get(searchGroup.groupValue);
            TopDocs topDocs = searchGroupDocs.collector.topDocs(n2, this.maxDocsPerGroup);
            groupDocsArray[n3++] = new GroupDocs(Float.NaN, topDocs.getMaxScore(), topDocs.totalHits, topDocs.scoreDocs, searchGroupDocs.groupValue, searchGroup.sortValues);
            f2 = Math.max(f2, topDocs.getMaxScore());
        }
        return new TopGroups(this.groupSort.getSort(), this.withinGroupSort == null ? null : this.withinGroupSort.getSort(), this.totalHitCount, this.totalGroupedHitCount, groupDocsArray, f2);
    }

    public class SearchGroupDocs<GROUP_VALUE_TYPE> {
        public final GROUP_VALUE_TYPE groupValue;
        public final TopDocsCollector<?> collector;
        public g leafCollector;

        public SearchGroupDocs(GROUP_VALUE_TYPE GROUP_VALUE_TYPE, TopDocsCollector<?> topDocsCollector) {
            this.groupValue = GROUP_VALUE_TYPE;
            this.collector = topDocsCollector;
        }
    }
}

