/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.TreeSet;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.grouping.CollectedSearchGroup;
import org.apache.lucene.search.grouping.SearchGroup;
import org.apache.lucene.search.h;
import org.apache.lucene.search.o;

public abstract class AbstractFirstPassGroupingCollector<GROUP_VALUE_TYPE>
extends o {
    private final Sort groupSort;
    private final FieldComparator<?>[] comparators;
    private final h[] leafComparators;
    private final int[] reversed;
    private final int topNGroups;
    private final HashMap<GROUP_VALUE_TYPE, CollectedSearchGroup<GROUP_VALUE_TYPE>> groupMap;
    private final int compIDXEnd;
    protected TreeSet<CollectedSearchGroup<GROUP_VALUE_TYPE>> orderedGroups;
    private int docBase;
    private int spareSlot;

    public AbstractFirstPassGroupingCollector(Sort sortFieldArray, int n2) throws IOException {
        if (n2 <= 0) {
            throw new IllegalArgumentException("topNGroups must be >= 1 (got " + n2 + ")");
        }
        this.groupSort = sortFieldArray;
        this.topNGroups = n2;
        sortFieldArray = sortFieldArray.getSort();
        this.comparators = new FieldComparator[sortFieldArray.length];
        this.leafComparators = new h[sortFieldArray.length];
        this.compIDXEnd = this.comparators.length - 1;
        this.reversed = new int[sortFieldArray.length];
        for (int i2 = 0; i2 < sortFieldArray.length; ++i2) {
            SortField sortField = sortFieldArray[i2];
            this.comparators[i2] = sortField.getComparator(n2 + 1, i2);
            this.reversed[i2] = sortField.getReverse() ? -1 : 1;
        }
        this.spareSlot = n2;
        this.groupMap = new HashMap(n2);
    }

    public Collection<SearchGroup<GROUP_VALUE_TYPE>> getTopGroups(int n2, boolean bl) {
        if (n2 < 0) {
            throw new IllegalArgumentException("groupOffset must be >= 0 (got " + n2 + ")");
        }
        if (this.groupMap.size() <= n2) {
            return null;
        }
        if (this.orderedGroups == null) {
            this.buildSortedSet();
        }
        ArrayList<SearchGroup<GROUP_VALUE_TYPE>> arrayList = new ArrayList<SearchGroup<GROUP_VALUE_TYPE>>();
        int n3 = 0;
        int n4 = this.groupSort.getSort().length;
        for (CollectedSearchGroup<GROUP_VALUE_TYPE> collectedSearchGroup : this.orderedGroups) {
            if (n3++ < n2) continue;
            SearchGroup searchGroup = new SearchGroup();
            new SearchGroup().groupValue = collectedSearchGroup.groupValue;
            if (bl) {
                searchGroup.sortValues = new Object[n4];
                for (int i2 = 0; i2 < n4; ++i2) {
                    searchGroup.sortValues[i2] = this.comparators[i2].value(collectedSearchGroup.comparatorSlot);
                }
            }
            arrayList.add(searchGroup);
        }
        return arrayList;
    }

    @Override
    public void setScorer(Scorer scorer) throws IOException {
        h[] hArray = this.leafComparators;
        int n2 = this.leafComparators.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            hArray[i2].setScorer(scorer);
        }
    }

    @Override
    public void collect(int n2) throws IOException {
        CollectedSearchGroup<GROUP_VALUE_TYPE> collectedSearchGroup;
        int n3;
        Object object;
        h[] hArray;
        if (this.orderedGroups != null) {
            int n4 = 0;
            while (true) {
                int n5;
                if ((n5 = this.reversed[n4] * this.leafComparators[n4].compareBottom(n2)) < 0) {
                    return;
                }
                if (n5 > 0) break;
                if (n4 == this.compIDXEnd) {
                    return;
                }
                ++n4;
            }
        }
        if ((hArray = this.groupMap.get(object = this.getDocGroupValue(n2))) == null) {
            int n6;
            if (this.groupMap.size() < this.topNGroups) {
                CollectedSearchGroup collectedSearchGroup2 = new CollectedSearchGroup();
                new CollectedSearchGroup().groupValue = this.copyDocGroupValue(object, null);
                collectedSearchGroup2.comparatorSlot = this.groupMap.size();
                collectedSearchGroup2.topDoc = this.docBase + n2;
                object = this.leafComparators;
                int n7 = this.leafComparators.length;
                for (int i2 = 0; i2 < n7; ++i2) {
                    object[i2].copy(collectedSearchGroup2.comparatorSlot, n2);
                }
                this.groupMap.put(collectedSearchGroup2.groupValue, collectedSearchGroup2);
                if (this.groupMap.size() == this.topNGroups) {
                    this.buildSortedSet();
                }
                return;
            }
            CollectedSearchGroup<GROUP_VALUE_TYPE> collectedSearchGroup3 = this.orderedGroups.pollLast();
            assert (this.orderedGroups.size() == this.topNGroups - 1);
            this.groupMap.remove(collectedSearchGroup3.groupValue);
            collectedSearchGroup3.groupValue = this.copyDocGroupValue(object, collectedSearchGroup3.groupValue);
            collectedSearchGroup3.topDoc = this.docBase + n2;
            object = this.leafComparators;
            int n8 = this.leafComparators.length;
            for (n6 = 0; n6 < n8; ++n6) {
                object[n6].copy(collectedSearchGroup3.comparatorSlot, n2);
            }
            this.groupMap.put(collectedSearchGroup3.groupValue, collectedSearchGroup3);
            this.orderedGroups.add(collectedSearchGroup3);
            assert (this.orderedGroups.size() == this.topNGroups);
            int n9 = this.orderedGroups.last().comparatorSlot;
            h[] hArray2 = this.leafComparators;
            n6 = this.leafComparators.length;
            for (int i3 = 0; i3 < n6; ++i3) {
                hArray2[i3].setBottom(n9);
            }
            return;
        }
        int n10 = 0;
        while (true) {
            this.leafComparators[n10].copy(this.spareSlot, n2);
            n3 = this.reversed[n10] * this.comparators[n10].compare(hArray.comparatorSlot, this.spareSlot);
            if (n3 < 0) {
                return;
            }
            if (n3 > 0) {
                for (int i4 = n10 + 1; i4 < this.comparators.length; ++i4) {
                    this.leafComparators[i4].copy(this.spareSlot, n2);
                }
                break;
            }
            if (n10 == this.compIDXEnd) {
                return;
            }
            ++n10;
        }
        if (this.orderedGroups != null) {
            collectedSearchGroup = this.orderedGroups.last();
            this.orderedGroups.remove(hArray);
            assert (this.orderedGroups.size() == this.topNGroups - 1);
        } else {
            collectedSearchGroup = null;
        }
        hArray.topDoc = this.docBase + n2;
        n3 = this.spareSlot;
        this.spareSlot = hArray.comparatorSlot;
        hArray.comparatorSlot = n3;
        if (this.orderedGroups != null) {
            this.orderedGroups.add((CollectedSearchGroup<GROUP_VALUE_TYPE>)hArray);
            assert (this.orderedGroups.size() == this.topNGroups);
            CollectedSearchGroup<GROUP_VALUE_TYPE> collectedSearchGroup4 = this.orderedGroups.last();
            if (hArray == collectedSearchGroup4 || collectedSearchGroup != collectedSearchGroup4) {
                hArray = this.leafComparators;
                int n11 = this.leafComparators.length;
                for (n2 = 0; n2 < n11; ++n2) {
                    hArray[n2].setBottom(collectedSearchGroup4.comparatorSlot);
                }
            }
        }
    }

    private void buildSortedSet() {
        Comparator comparator = new Comparator<CollectedSearchGroup<?>>(){

            @Override
            public int compare(CollectedSearchGroup<?> collectedSearchGroup, CollectedSearchGroup<?> collectedSearchGroup2) {
                int n2 = 0;
                while (true) {
                    FieldComparator fieldComparator = AbstractFirstPassGroupingCollector.this.comparators[n2];
                    int n3 = AbstractFirstPassGroupingCollector.this.reversed[n2] * fieldComparator.compare(collectedSearchGroup.comparatorSlot, collectedSearchGroup2.comparatorSlot);
                    if (n3 != 0) {
                        return n3;
                    }
                    if (n2 == AbstractFirstPassGroupingCollector.this.compIDXEnd) {
                        return collectedSearchGroup.topDoc - collectedSearchGroup2.topDoc;
                    }
                    ++n2;
                }
            }
        };
        this.orderedGroups = new TreeSet(comparator);
        this.orderedGroups.addAll(this.groupMap.values());
        assert (this.orderedGroups.size() > 0);
        comparator = this.leafComparators;
        int n2 = ((h[])this.leafComparators).length;
        for (int i2 = 0; i2 < n2; ++i2) {
            comparator[i2].setBottom(this.orderedGroups.last().comparatorSlot);
        }
    }

    @Override
    protected void doSetNextReader(LeafReaderContext leafReaderContext) throws IOException {
        this.docBase = leafReaderContext.docBase;
        for (int i2 = 0; i2 < this.comparators.length; ++i2) {
            this.leafComparators[i2] = this.comparators[i2].getLeafComparator(leafReaderContext);
        }
    }

    protected abstract GROUP_VALUE_TYPE getDocGroupValue(int var1);

    protected abstract GROUP_VALUE_TYPE copyDocGroupValue(GROUP_VALUE_TYPE var1, GROUP_VALUE_TYPE var2);
}

