/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search.grouping;

import java.io.IOException;
import java.util.Collection;
import org.apache.lucene.search.o;
import org.apache.lucene.util.FixedBitSet;

public abstract class AbstractAllGroupHeadsCollector<GH extends GroupHead>
extends o {
    protected final int[] reversed;
    protected final int compIDXEnd;
    protected final TemporalResult temporalResult;

    protected AbstractAllGroupHeadsCollector(int n2) {
        this.reversed = new int[n2];
        this.compIDXEnd = n2 - 1;
        this.temporalResult = new TemporalResult();
    }

    public FixedBitSet retrieveGroupHeads(int n2) {
        FixedBitSet fixedBitSet = new FixedBitSet(n2);
        for (GroupHead groupHead : this.getCollectedGroupHeads()) {
            fixedBitSet.set(groupHead.doc);
        }
        return fixedBitSet;
    }

    protected abstract void retrieveGroupHeadAndAddIfNotExist(int var1) throws IOException;

    protected abstract Collection<GH> getCollectedGroupHeads();

    @Override
    public void collect(int n2) throws IOException {
        this.retrieveGroupHeadAndAddIfNotExist(n2);
        if (this.temporalResult.stop) {
            return;
        }
        Object GH = this.temporalResult.groupHead;
        int n3 = 0;
        while (true) {
            int n4;
            if ((n4 = this.reversed[n3] * ((GroupHead)GH).compare(n3, n2)) < 0) {
                return;
            }
            if (n4 > 0) break;
            if (n3 == this.compIDXEnd) {
                return;
            }
            ++n3;
        }
        ((GroupHead)GH).updateDocHead(n2);
    }

    public static abstract class GroupHead<GROUP_VALUE_TYPE> {
        public final GROUP_VALUE_TYPE groupValue;
        public int doc;

        protected GroupHead(GROUP_VALUE_TYPE GROUP_VALUE_TYPE, int n2) {
            this.groupValue = GROUP_VALUE_TYPE;
            this.doc = n2;
        }

        protected abstract int compare(int var1, int var2) throws IOException;

        protected abstract void updateDocHead(int var1) throws IOException;
    }

    protected class TemporalResult {
        public GH groupHead;
        public boolean stop;

        protected TemporalResult() {
        }
    }
}

