/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.portmobile.util.Objects;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.a.a;

public abstract class TwoPhaseIterator {
    protected final DocIdSetIterator approximation;

    protected TwoPhaseIterator(DocIdSetIterator docIdSetIterator) {
        this.approximation = Objects.requireNonNull(docIdSetIterator);
    }

    public static DocIdSetIterator asDocIdSetIterator(final TwoPhaseIterator twoPhaseIterator) {
        final DocIdSetIterator docIdSetIterator = twoPhaseIterator.approximation();
        return new DocIdSetIterator(){

            @Override
            public final int docID() {
                return docIdSetIterator.docID();
            }

            @Override
            public final int nextDoc() throws IOException {
                return this.doNext(docIdSetIterator.nextDoc());
            }

            @Override
            public final int advance(int n2) throws IOException {
                return this.doNext(docIdSetIterator.advance(n2));
            }

            private int doNext(int n2) throws IOException {
                while (n2 != Integer.MAX_VALUE) {
                    if (twoPhaseIterator.matches()) {
                        return n2;
                    }
                    n2 = docIdSetIterator.nextDoc();
                }
                return Integer.MAX_VALUE;
            }

            @Override
            public final long cost() {
                return docIdSetIterator.cost();
            }
        };
    }

    public DocIdSetIterator approximation() {
        return this.approximation;
    }

    public abstract boolean matches() throws IOException;

    public static TwoPhaseIterator asTwoPhaseIterator(DocIdSetIterator docIdSetIterator) {
        if (docIdSetIterator instanceof Scorer) {
            return ((Scorer)docIdSetIterator).asTwoPhaseIterator();
        }
        if (docIdSetIterator instanceof a) {
            return a.c();
        }
        return null;
    }
}

