/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopDocsCollector;
import org.apache.lucene.search.f;
import org.apache.lucene.search.g;

public abstract class TopScoreDocCollector
extends TopDocsCollector<ScoreDoc> {
    ScoreDoc pqTop;

    public static TopScoreDocCollector create(int n2) {
        return TopScoreDocCollector.create(n2, null);
    }

    public static TopScoreDocCollector create(int n2, ScoreDoc scoreDoc) {
        if (n2 <= 0) {
            throw new IllegalArgumentException("numHits must be > 0; please use TotalHitCountCollector if you just need the total hit count");
        }
        if (scoreDoc == null) {
            return new a(n2);
        }
        return new PagingTopScoreDocCollector(n2, scoreDoc);
    }

    TopScoreDocCollector(int n2) {
        super(new f(n2));
        this.pqTop = (ScoreDoc)this.pq.top();
    }

    @Override
    protected TopDocs newTopDocs(ScoreDoc[] scoreDocArray, int n2) {
        float f2;
        if (scoreDocArray == null) {
            return EMPTY_TOPDOCS;
        }
        if (n2 == 0) {
            f2 = scoreDocArray[0].score;
        } else {
            for (n2 = this.pq.size(); n2 > 1; --n2) {
                this.pq.pop();
            }
            f2 = ((ScoreDoc)this.pq.pop()).score;
        }
        return new TopDocs(this.totalHits, scoreDocArray, f2);
    }

    @Override
    public boolean needsScores() {
        return true;
    }

    private static class PagingTopScoreDocCollector
    extends TopScoreDocCollector {
        private final ScoreDoc after;
        private int collectedHits;

        PagingTopScoreDocCollector(int n2, ScoreDoc scoreDoc) {
            super(n2);
            this.after = scoreDoc;
            this.collectedHits = 0;
        }

        @Override
        protected int topDocsSize() {
            if (this.collectedHits < this.pq.size()) {
                return this.collectedHits;
            }
            return this.pq.size();
        }

        @Override
        protected TopDocs newTopDocs(ScoreDoc[] scoreDocArray, int n2) {
            if (scoreDocArray == null) {
                return new TopDocs(this.totalHits, new ScoreDoc[0], Float.NaN);
            }
            return new TopDocs(this.totalHits, scoreDocArray);
        }

        @Override
        public g getLeafCollector(LeafReaderContext leafReaderContext) throws IOException {
            final int n2 = leafReaderContext.docBase;
            final int n3 = this.after.doc - leafReaderContext.docBase;
            return new ScorerLeafCollector(){

                @Override
                public void collect(int n22) throws IOException {
                    float f2 = this.scorer.score();
                    assert (f2 != Float.NEGATIVE_INFINITY);
                    assert (!Float.isNaN(f2));
                    ++PagingTopScoreDocCollector.this.totalHits;
                    if (f2 > ((PagingTopScoreDocCollector)PagingTopScoreDocCollector.this).after.score || f2 == ((PagingTopScoreDocCollector)PagingTopScoreDocCollector.this).after.score && n22 <= n3) {
                        return;
                    }
                    if (f2 <= PagingTopScoreDocCollector.this.pqTop.score) {
                        return;
                    }
                    PagingTopScoreDocCollector.this.collectedHits++;
                    PagingTopScoreDocCollector.this.pqTop.doc = n22 + n2;
                    PagingTopScoreDocCollector.this.pqTop.score = f2;
                    PagingTopScoreDocCollector.this.pqTop = (ScoreDoc)PagingTopScoreDocCollector.this.pq.updateTop();
                }
            };
        }
    }

    private static final class a
    extends TopScoreDocCollector {
        a(int n2) {
            super(n2);
        }

        @Override
        public final g getLeafCollector(LeafReaderContext leafReaderContext) throws IOException {
            int n2 = leafReaderContext.docBase;
            return new ScorerLeafCollector(this, n2){
                static final /* synthetic */ boolean $assertionsDisabled;
                final /* synthetic */ int val$docBase;
                final /* synthetic */ a this$0;
                {
                    this.this$0 = a2;
                    this.val$docBase = n2;
                }

                public void collect(int n2) throws IOException {
                    float f2 = this.scorer.score();
                    if (!$assertionsDisabled && f2 == Float.NEGATIVE_INFINITY) {
                        throw new AssertionError();
                    }
                    if (!$assertionsDisabled && Float.isNaN(f2)) {
                        throw new AssertionError();
                    }
                    ++this.this$0.totalHits;
                    if (f2 <= this.this$0.pqTop.score) {
                        return;
                    }
                    this.this$0.pqTop.doc = n2 + this.val$docBase;
                    this.this$0.pqTop.score = f2;
                    this.this$0.pqTop = (ScoreDoc)this.this$0.pq.updateTop();
                }

                static {
                    $assertionsDisabled = !TopScoreDocCollector.class.desiredAssertionStatus();
                }
            };
        }
    }

    static abstract class ScorerLeafCollector
    implements g {
        Scorer scorer;

        ScorerLeafCollector() {
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
        }
    }
}

