/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.util.PriorityQueue;

public class TopDocs {
    public int totalHits;
    public ScoreDoc[] scoreDocs;
    private float maxScore;

    public float getMaxScore() {
        return this.maxScore;
    }

    TopDocs(int n2, ScoreDoc[] scoreDocArray) {
        this(n2, scoreDocArray, Float.NaN);
    }

    public TopDocs(int n2, ScoreDoc[] scoreDocArray, float f2) {
        this.totalHits = n2;
        this.scoreDocs = scoreDocArray;
        this.maxScore = f2;
    }

    public static TopDocs merge(int n2, TopDocs[] topDocsArray) throws IOException {
        return TopDocs.merge(0, n2, topDocsArray);
    }

    public static TopDocs merge(int n2, int n3, TopDocs[] topDocsArray) throws IOException {
        return TopDocs.mergeAux(null, n2, n3, topDocsArray);
    }

    public static TopFieldDocs merge(Sort sort, int n2, TopFieldDocs[] topFieldDocsArray) throws IOException {
        return TopDocs.merge(sort, 0, n2, topFieldDocsArray);
    }

    public static TopFieldDocs merge(Sort sort, int n2, int n3, TopFieldDocs[] topFieldDocsArray) throws IOException {
        if (sort == null) {
            throw new IllegalArgumentException("sort must be non-null when merging field-docs");
        }
        return (TopFieldDocs)TopDocs.mergeAux(sort, n2, n3, topFieldDocsArray);
    }

    private static TopDocs mergeAux(Sort sort, int n2, int n3, TopDocs[] topDocsArray) throws IOException {
        ScoreDoc[] scoreDocArray;
        PriorityQueue priorityQueue = sort == null ? new ScoreMergeSortQueue(topDocsArray) : new MergeSortQueue(sort, topDocsArray);
        int n4 = 0;
        int n5 = 0;
        float f2 = Float.MIN_VALUE;
        for (int i2 = 0; i2 < topDocsArray.length; ++i2) {
            TopDocs topDocs = topDocsArray[i2];
            n4 += topDocs.totalHits;
            if (topDocs.scoreDocs == null || topDocs.scoreDocs.length <= 0) continue;
            n5 += topDocs.scoreDocs.length;
            priorityQueue.add(new ShardRef(i2));
            f2 = Math.max(f2, topDocs.getMaxScore());
        }
        if (n5 == 0) {
            f2 = Float.NaN;
        }
        if (n5 <= n2) {
            scoreDocArray = new ScoreDoc[]{};
        } else {
            scoreDocArray = new ScoreDoc[Math.min(n3, n5 - n2)];
            int n6 = n2 + n3;
            n3 = Math.min(n5, n6);
            for (n5 = 0; n5 < n3; ++n5) {
                assert (priorityQueue.size() > 0);
                ShardRef shardRef = (ShardRef)priorityQueue.pop();
                ScoreDoc scoreDoc = topDocsArray[shardRef.shardIndex].scoreDocs[shardRef.hitIndex++];
                topDocsArray[shardRef.shardIndex].scoreDocs[shardRef.hitIndex++].shardIndex = shardRef.shardIndex;
                if (n5 < n2) continue;
                scoreDocArray[n5 - n2] = scoreDoc;
                if (shardRef.hitIndex >= topDocsArray[shardRef.shardIndex].scoreDocs.length) continue;
                priorityQueue.add(shardRef);
            }
        }
        if (sort == null) {
            return new TopDocs(n4, scoreDocArray, f2);
        }
        return new TopFieldDocs(n4, scoreDocArray, sort.getSort(), f2);
    }

    private static class MergeSortQueue
    extends PriorityQueue<ShardRef> {
        final ScoreDoc[][] shardHits;
        final FieldComparator<?>[] comparators;
        final int[] reverseMul;

        public MergeSortQueue(Sort sort, TopDocs[] topDocsArray) throws IOException {
            super(topDocsArray.length);
            this.shardHits = new ScoreDoc[topDocsArray.length][];
            for (int i2 = 0; i2 < topDocsArray.length; ++i2) {
                ScoreDoc[] scoreDocArray = topDocsArray[i2].scoreDocs;
                if (topDocsArray[i2].scoreDocs == null) continue;
                this.shardHits[i2] = scoreDocArray;
                for (int i3 = 0; i3 < scoreDocArray.length; ++i3) {
                    ScoreDoc scoreDoc = scoreDocArray[i3];
                    if (!(scoreDoc instanceof FieldDoc)) {
                        throw new IllegalArgumentException("shard " + i2 + " was not sorted by the provided Sort (expected FieldDoc but got ScoreDoc)");
                    }
                    if (((FieldDoc)scoreDoc).fields != null) continue;
                    throw new IllegalArgumentException("shard " + i2 + " did not set sort field values (FieldDoc.fields is null); you must pass fillFields=true to IndexSearcher.search on each shard");
                }
            }
            SortField[] sortFieldArray = sort.getSort();
            this.comparators = new FieldComparator[sortFieldArray.length];
            this.reverseMul = new int[sortFieldArray.length];
            for (int i4 = 0; i4 < sortFieldArray.length; ++i4) {
                SortField sortField = sortFieldArray[i4];
                this.comparators[i4] = sortField.getComparator(1, i4);
                this.reverseMul[i4] = sortField.getReverse() ? -1 : 1;
            }
        }

        @Override
        public boolean lessThan(ShardRef shardRef, ShardRef shardRef2) {
            assert (shardRef != shardRef2);
            FieldDoc fieldDoc = (FieldDoc)this.shardHits[shardRef.shardIndex][shardRef.hitIndex];
            FieldDoc fieldDoc2 = (FieldDoc)this.shardHits[shardRef2.shardIndex][shardRef2.hitIndex];
            for (int i2 = 0; i2 < this.comparators.length; ++i2) {
                FieldComparator<?> fieldComparator = this.comparators[i2];
                int n2 = this.reverseMul[i2] * fieldComparator.compareValues(fieldDoc.fields[i2], fieldDoc2.fields[i2]);
                if (n2 == 0) continue;
                return n2 < 0;
            }
            if (shardRef.shardIndex < shardRef2.shardIndex) {
                return true;
            }
            if (shardRef.shardIndex > shardRef2.shardIndex) {
                return false;
            }
            assert (shardRef.hitIndex != shardRef2.hitIndex);
            return shardRef.hitIndex < shardRef2.hitIndex;
        }
    }

    private static class ScoreMergeSortQueue
    extends PriorityQueue<ShardRef> {
        final ScoreDoc[][] shardHits;

        public ScoreMergeSortQueue(TopDocs[] topDocsArray) {
            super(topDocsArray.length);
            this.shardHits = new ScoreDoc[topDocsArray.length][];
            for (int i2 = 0; i2 < topDocsArray.length; ++i2) {
                this.shardHits[i2] = topDocsArray[i2].scoreDocs;
            }
        }

        @Override
        public boolean lessThan(ShardRef shardRef, ShardRef shardRef2) {
            assert (shardRef != shardRef2);
            float f2 = this.shardHits[shardRef.shardIndex][shardRef.hitIndex].score;
            float f3 = this.shardHits[shardRef2.shardIndex][shardRef2.hitIndex].score;
            if (f2 < f3) {
                return false;
            }
            if (f2 > f3) {
                return true;
            }
            if (shardRef.shardIndex < shardRef2.shardIndex) {
                return true;
            }
            if (shardRef.shardIndex > shardRef2.shardIndex) {
                return false;
            }
            assert (shardRef.hitIndex != shardRef2.hitIndex);
            return shardRef.hitIndex < shardRef2.hitIndex;
        }
    }

    private static class ShardRef {
        final int shardIndex;
        int hitIndex;

        public ShardRef(int n2) {
            this.shardIndex = n2;
        }

        public String toString() {
            return "ShardRef(shardIndex=" + this.shardIndex + " hitIndex=" + this.hitIndex + ")";
        }
    }
}

