/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.o;
import org.apache.lucene.index.q;
import org.apache.lucene.portmobile.util.Objects;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermScorer;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.a;
import org.apache.lucene.util.ToStringUtils;

public class TermQuery
extends Query {
    private final Term term;
    private final TermContext perReaderTermState;

    public TermQuery(Term term) {
        this.term = Objects.requireNonNull(term);
        this.perReaderTermState = null;
    }

    public TermQuery(Term term, TermContext termContext) {
        assert (termContext != null);
        this.term = Objects.requireNonNull(term);
        if (!termContext.hasOnlyRealTerms()) {
            throw new IllegalArgumentException("Term queries must be created on real terms");
        }
        this.perReaderTermState = Objects.requireNonNull(termContext);
    }

    @Override
    public Weight createWeight(IndexSearcher indexSearcher, boolean bl) throws IOException {
        Object object = indexSearcher.getTopReaderContext();
        object = this.perReaderTermState == null || this.perReaderTermState.topReaderContext != object ? TermContext.build((IndexReaderContext)object, this.term) : this.perReaderTermState;
        return new TermWeight(indexSearcher, bl, (TermContext)object);
    }

    @Override
    public String toString(String string) {
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.term.field().equals(string)) {
            stringBuilder.append(this.term.field());
            stringBuilder.append(":");
        }
        stringBuilder.append(this.term.text());
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof TermQuery)) {
            return false;
        }
        TermQuery termQuery = (TermQuery)object;
        return super.equals(object) && this.term.equals(termQuery.term);
    }

    @Override
    public int hashCode() {
        return super.hashCode() ^ this.term.hashCode();
    }

    final class TermWeight
    extends Weight {
        private final a similarity;
        private final a.b stats;
        private final TermContext termStates;
        private final boolean needsScores;

        public TermWeight(IndexSearcher object, boolean bl, TermContext termContext) throws IOException {
            CollectionStatistics collectionStatistics;
            super(TermQuery.this);
            this.needsScores = bl;
            assert (termContext != null) : "TermContext must not be null";
            assert (termContext.hasOnlyRealTerms());
            this.termStates = termContext;
            this.similarity = ((IndexSearcher)object).getSimilarity(bl);
            if (bl) {
                collectionStatistics = ((IndexSearcher)object).collectionStatistics(TermQuery.this.term.field());
                object = ((IndexSearcher)object).termStatistics(TermQuery.this.term, termContext);
            } else {
                int n2 = ((IndexSearcher)object).getIndexReader().maxDoc();
                int n3 = termContext.docFreq();
                long l2 = termContext.totalTermFreq();
                collectionStatistics = new CollectionStatistics(TermQuery.this.term.field(), n2, -1L, -1L, -1L);
                object = new TermStatistics(TermQuery.this.term.bytes(), n3, l2);
            }
            this.stats = this.similarity.computeWeight(TermQuery.this.getBoost(), collectionStatistics, new TermStatistics[]{object});
        }

        public final String toString() {
            return "weight(" + TermQuery.this + ")";
        }

        @Override
        public final float getValueForNormalization() {
            return this.stats.getValueForNormalization();
        }

        @Override
        public final void normalize(float f2, float f3) {
            this.stats.normalize(f2, f3);
        }

        @Override
        public final Scorer scorer(LeafReaderContext leafReaderContext) throws IOException {
            assert (this.termStates.topReaderContext == o.a(leafReaderContext)) : "The top-reader used to create Weight (" + this.termStates.topReaderContext + ") is not the same as the current reader's top-reader (" + o.a(leafReaderContext);
            Object object = this.getTermsEnum(leafReaderContext);
            if (object == null) {
                return null;
            }
            object = ((TermsEnum)object).postings(null, this.needsScores ? 8 : 0);
            assert (object != null);
            return new TermScorer(this, (PostingsEnum)object, this.similarity.simScorer(this.stats, leafReaderContext));
        }

        private TermsEnum getTermsEnum(LeafReaderContext object) throws IOException {
            q q2 = this.termStates.get(((LeafReaderContext)object).ord);
            if (q2 == null) {
                assert (this.termNotInReader(((LeafReaderContext)object).reader(), TermQuery.this.term)) : "no termstate found but term exists in reader term=" + TermQuery.access$000(TermQuery.this);
                return null;
            }
            object = ((LeafReaderContext)object).reader().terms(TermQuery.this.term.field()).iterator();
            ((TermsEnum)object).seekExact(TermQuery.this.term.bytes(), q2);
            return object;
        }

        private boolean termNotInReader(LeafReader leafReader, Term term) throws IOException {
            return leafReader.docFreq(term) == 0;
        }
    }
}

