/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.util.AttributeSource;
import org.apache.lucene.util.BytesRef;

abstract class TermCollectingRewrite<B>
extends MultiTermQuery.a {
    TermCollectingRewrite() {
    }

    protected abstract B getTopLevelBuilder() throws IOException;

    protected abstract Query build(B var1);

    protected abstract void addClause(B var1, Term var2, int var3, float var4, TermContext var5) throws IOException;

    final void collectTerms(IndexReader object, MultiTermQuery multiTermQuery, TermCollector termCollector) throws IOException {
        object = ((IndexReader)object).getContext();
        for (LeafReaderContext leafReaderContext : ((IndexReaderContext)object).leaves()) {
            BytesRef bytesRef;
            Object object2 = leafReaderContext.reader().terms(multiTermQuery.field);
            if (object2 == null) continue;
            object2 = this.getTermsEnum(multiTermQuery, (Terms)object2, termCollector.attributes);
            assert (object2 != null);
            if (object2 == TermsEnum.EMPTY) continue;
            termCollector.setReaderContext((IndexReaderContext)object, leafReaderContext);
            termCollector.setNextEnum((TermsEnum)object2);
            while ((bytesRef = object2.next()) != null) {
                if (termCollector.collect(bytesRef)) continue;
                return;
            }
        }
    }

    static abstract class TermCollector {
        protected LeafReaderContext readerContext;
        protected IndexReaderContext topReaderContext;
        public final AttributeSource attributes = new AttributeSource();

        TermCollector() {
        }

        public void setReaderContext(IndexReaderContext indexReaderContext, LeafReaderContext leafReaderContext) {
            this.readerContext = leafReaderContext;
            this.topReaderContext = indexReaderContext;
        }

        public abstract boolean collect(BytesRef var1) throws IOException;

        public abstract void setNextEnum(TermsEnum var1) throws IOException;
    }
}

