/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.ReferenceManager;
import org.apache.lucene.search.n;

public final class SearcherManager
extends ReferenceManager<IndexSearcher> {
    private final n searcherFactory;

    public SearcherManager(IndexWriter indexWriter, boolean bl, n n2) throws IOException {
        if (n2 == null) {
            n2 = new n();
        }
        this.searcherFactory = n2;
        this.current = SearcherManager.getSearcher(n2, DirectoryReader.open(indexWriter, bl), null);
    }

    @Override
    protected final void decRef(IndexSearcher indexSearcher) throws IOException {
        indexSearcher.getIndexReader().decRef();
    }

    @Override
    protected final IndexSearcher refreshIfNeeded(IndexSearcher object) throws IOException {
        object = ((IndexSearcher)object).getIndexReader();
        assert (object instanceof DirectoryReader) : "searcher's IndexReader should be a DirectoryReader, but got " + object;
        DirectoryReader directoryReader = DirectoryReader.openIfChanged((DirectoryReader)object);
        if (directoryReader == null) {
            return null;
        }
        return SearcherManager.getSearcher(this.searcherFactory, directoryReader, (IndexReader)object);
    }

    @Override
    protected final boolean tryIncRef(IndexSearcher indexSearcher) {
        return indexSearcher.getIndexReader().tryIncRef();
    }

    @Override
    protected final int getRefCount(IndexSearcher indexSearcher) {
        return indexSearcher.getIndexReader().getRefCount();
    }

    public static IndexSearcher getSearcher(n object, IndexReader indexReader, IndexReader indexReader2) throws IOException {
        try {
            object = indexReader;
            object = new IndexSearcher((IndexReader)object);
            if (((IndexSearcher)object).getIndexReader() != indexReader) {
                throw new IllegalStateException("SearcherFactory must wrap exactly the provided reader (got " + ((IndexSearcher)object).getIndexReader() + " but expected " + indexReader + ")");
            }
        }
        catch (Throwable throwable) {
            indexReader.decRef();
            throw throwable;
        }
        return object;
    }
}

