/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;

class ReqOptSumScorer
extends Scorer {
    protected final Scorer reqScorer;
    protected Scorer optScorer;

    public ReqOptSumScorer(Scorer scorer, Scorer scorer2) {
        super(scorer.weight);
        assert (scorer != null);
        assert (scorer2 != null);
        this.reqScorer = scorer;
        this.optScorer = scorer2;
    }

    @Override
    public TwoPhaseIterator asTwoPhaseIterator() {
        return this.reqScorer.asTwoPhaseIterator();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.reqScorer.nextDoc();
    }

    @Override
    public int advance(int n2) throws IOException {
        return this.reqScorer.advance(n2);
    }

    @Override
    public int docID() {
        return this.reqScorer.docID();
    }

    @Override
    public float score() throws IOException {
        int n2 = this.reqScorer.docID();
        float f2 = this.reqScorer.score();
        if (this.optScorer == null) {
            return f2;
        }
        int n3 = this.optScorer.docID();
        if (n3 < n2 && (n3 = this.optScorer.advance(n2)) == Integer.MAX_VALUE) {
            this.optScorer = null;
            return f2;
        }
        if (n3 == n2) {
            return f2 + this.optScorer.score();
        }
        return f2;
    }

    @Override
    public int freq() throws IOException {
        this.score();
        if (this.optScorer != null && this.optScorer.docID() == this.reqScorer.docID()) {
            return 2;
        }
        return 1;
    }

    @Override
    public long cost() {
        return this.reqScorer.cost();
    }
}

