/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TwoPhaseIterator;

class ReqExclScorer
extends Scorer {
    private final Scorer reqScorer;
    private final DocIdSetIterator reqApproximation;
    private final DocIdSetIterator exclApproximation;
    private final TwoPhaseIterator reqTwoPhaseIterator;
    private final TwoPhaseIterator exclTwoPhaseIterator;

    public ReqExclScorer(Scorer scorer, Scorer scorer2) {
        super(scorer.weight);
        this.reqScorer = scorer;
        this.reqTwoPhaseIterator = scorer.asTwoPhaseIterator();
        this.reqApproximation = this.reqTwoPhaseIterator == null ? scorer : this.reqTwoPhaseIterator.approximation();
        this.exclTwoPhaseIterator = scorer2.asTwoPhaseIterator();
        if (this.exclTwoPhaseIterator == null) {
            this.exclApproximation = scorer2;
            return;
        }
        this.exclApproximation = this.exclTwoPhaseIterator.approximation();
    }

    @Override
    public int nextDoc() throws IOException {
        return this.toNonExcluded(this.reqApproximation.nextDoc());
    }

    private static boolean matches(TwoPhaseIterator twoPhaseIterator) throws IOException {
        return twoPhaseIterator == null || twoPhaseIterator.matches();
    }

    private static boolean matches(int n2, int n3, TwoPhaseIterator twoPhaseIterator, TwoPhaseIterator twoPhaseIterator2) throws IOException {
        assert (n3 >= n2);
        if (n2 == n3 && ReqExclScorer.matches(twoPhaseIterator2)) {
            return false;
        }
        return ReqExclScorer.matches(twoPhaseIterator);
    }

    private int toNonExcluded(int n2) throws IOException {
        int n3 = this.exclApproximation.docID();
        while (n2 != Integer.MAX_VALUE) {
            if (n3 < n2) {
                n3 = this.exclApproximation.advance(n2);
            }
            if (ReqExclScorer.matches(n2, n3, this.reqTwoPhaseIterator, this.exclTwoPhaseIterator)) {
                return n2;
            }
            n2 = this.reqApproximation.nextDoc();
        }
        return Integer.MAX_VALUE;
    }

    @Override
    public int docID() {
        return this.reqScorer.docID();
    }

    @Override
    public int freq() throws IOException {
        return this.reqScorer.freq();
    }

    @Override
    public long cost() {
        return this.reqScorer.cost();
    }

    @Override
    public float score() throws IOException {
        return this.reqScorer.score();
    }

    @Override
    public int advance(int n2) throws IOException {
        return this.toNonExcluded(this.reqApproximation.advance(n2));
    }

    @Override
    public TwoPhaseIterator asTwoPhaseIterator() {
        if (this.reqTwoPhaseIterator == null) {
            return null;
        }
        return new TwoPhaseIterator(this.reqApproximation){

            @Override
            public boolean matches() throws IOException {
                int n2 = ReqExclScorer.this.reqApproximation.docID();
                int n3 = ReqExclScorer.this.exclApproximation.docID();
                if (n3 < n2) {
                    n3 = ReqExclScorer.this.exclApproximation.advance(n2);
                }
                return ReqExclScorer.matches(n2, n3, ReqExclScorer.this.reqTwoPhaseIterator, ReqExclScorer.this.exclTwoPhaseIterator);
            }
        };
    }
}

