/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.Closeable;
import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.lucene.store.a;

public abstract class ReferenceManager<G>
implements Closeable {
    protected volatile G current;
    private final Lock refreshLock = new ReentrantLock();
    private final List<Object> refreshListeners = new CopyOnWriteArrayList<Object>();

    private void ensureOpen() {
        if (this.current == null) {
            throw new a("this ReferenceManager is closed");
        }
    }

    private synchronized void swapReference(G g2) throws IOException {
        this.ensureOpen();
        G g3 = this.current;
        this.current = g2;
        this.release(g3);
    }

    protected abstract void decRef(G var1) throws IOException;

    protected abstract G refreshIfNeeded(G var1) throws IOException;

    protected abstract boolean tryIncRef(G var1) throws IOException;

    public final G acquire() throws IOException {
        G g2;
        do {
            if ((g2 = this.current) == null) {
                throw new a("this ReferenceManager is closed");
            }
            if (!this.tryIncRef(g2)) continue;
            return g2;
        } while (this.getRefCount(g2) != 0 || this.current != g2);
        assert (g2 != null);
        throw new IllegalStateException("The managed reference has already closed - this is likely a bug when the reference count is modified outside of the ReferenceManager");
    }

    @Override
    public final synchronized void close() throws IOException {
        if (this.current != null) {
            this.swapReference(null);
            this.afterClose();
        }
    }

    protected abstract int getRefCount(G var1);

    protected void afterClose() throws IOException {
    }

    private void doMaybeRefresh() throws IOException {
        this.refreshLock.lock();
        boolean bl = false;
        try {
            block9: {
                G g2 = this.acquire();
                try {
                    this.notifyRefreshListenersBefore();
                    G g3 = this.refreshIfNeeded(g2);
                    if (g3 == null) break block9;
                    assert (g3 != g2) : "refreshIfNeeded should return null if refresh wasn't needed";
                    try {
                        this.swapReference(g3);
                        bl = true;
                    }
                    catch (Throwable throwable) {
                        this.release(g3);
                        throw throwable;
                    }
                }
                finally {
                    this.release(g2);
                    this.notifyRefreshListenersRefreshed(bl);
                }
            }
            this.afterMaybeRefresh();
            return;
        }
        finally {
            this.refreshLock.unlock();
        }
    }

    public final boolean maybeRefresh() throws IOException {
        this.ensureOpen();
        boolean bl = this.refreshLock.tryLock();
        if (bl) {
            try {
                this.doMaybeRefresh();
            }
            finally {
                this.refreshLock.unlock();
            }
        }
        return bl;
    }

    protected void afterMaybeRefresh() throws IOException {
    }

    public final void release(G g2) throws IOException {
        assert (g2 != null);
        this.decRef(g2);
    }

    private void notifyRefreshListenersBefore() throws IOException {
        Iterator<Object> iterator = this.refreshListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }

    private void notifyRefreshListenersRefreshed(boolean bl) throws IOException {
        Iterator<Object> iterator = this.refreshListeners.iterator();
        while (iterator.hasNext()) {
            iterator.next();
        }
    }
}

