/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Weight;

public abstract class Query
implements Cloneable {
    private float boost = 1.0f;

    public void setBoost(float f2) {
        this.boost = f2;
    }

    public float getBoost() {
        return this.boost;
    }

    public abstract String toString(String var1);

    public final String toString() {
        return this.toString("");
    }

    public Weight createWeight(IndexSearcher indexSearcher, boolean bl) throws IOException {
        throw new UnsupportedOperationException("Query " + this + " does not implement createWeight");
    }

    public Query rewrite(IndexReader indexReader) throws IOException {
        return this;
    }

    public Query clone() {
        try {
            return (Query)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            throw new RuntimeException("Clone not supported: " + cloneNotSupportedException.getMessage());
        }
    }

    public int hashCode() {
        return Float.floatToIntBits(this.getBoost()) ^ this.getClass().hashCode();
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        object = (Query)object;
        return Float.floatToIntBits(this.boost) == Float.floatToIntBits(((Query)object).boost);
    }
}

