/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.q;
import org.apache.lucene.search.ExactPhraseScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SloppyPhraseScorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.j;
import org.apache.lucene.search.similarities.a;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.ToStringUtils;

public class PhraseQuery
extends Query {
    private final boolean mutable;
    private int slop;
    private String field;
    private final List<Term> terms;
    private final List<Integer> positions;

    private PhraseQuery(int n2, Term[] termArray, int[] nArray) {
        int n3;
        int n4;
        if (termArray.length != nArray.length) {
            throw new IllegalArgumentException("Must have as many terms as positions");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("Slop must be >= 0, got " + n2);
        }
        for (int i2 = 1; i2 < termArray.length; ++i2) {
            if (termArray[i2 - 1].field().equals(termArray[i2].field())) continue;
            throw new IllegalArgumentException("All terms should have the same field");
        }
        int[] nArray2 = nArray;
        int n5 = nArray.length;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = nArray2[n4];
            if (n3 >= 0) continue;
            throw new IllegalArgumentException("Positions must be >= 0, got " + n3);
        }
        for (int i3 = 1; i3 < nArray.length; ++i3) {
            if (nArray[i3] >= nArray[i3 - 1]) continue;
            throw new IllegalArgumentException("Positions should not go backwards, got " + nArray[i3 - 1] + " before " + nArray[i3]);
        }
        this.slop = n2;
        this.terms = Arrays.asList(termArray);
        this.positions = new ArrayList<Integer>(nArray.length);
        int[] nArray3 = nArray;
        n5 = nArray.length;
        for (n4 = 0; n4 < n5; ++n4) {
            n3 = nArray3[n4];
            this.positions.add(n3);
        }
        this.field = termArray.length == 0 ? null : termArray[0].field();
        this.mutable = false;
    }

    public Term[] getTerms() {
        return this.terms.toArray(new Term[0]);
    }

    public int[] getPositions() {
        int[] nArray = new int[this.positions.size()];
        for (int i2 = 0; i2 < this.positions.size(); ++i2) {
            nArray[i2] = this.positions.get(i2);
        }
        return nArray;
    }

    @Override
    public Query rewrite(IndexReader object) throws IOException {
        if (this.terms.isEmpty()) {
            object = new j();
            ((Query)object).setBoost(this.getBoost());
            return object;
        }
        if (this.terms.size() == 1) {
            object = new TermQuery(this.terms.get(0));
            ((Query)object).setBoost(this.getBoost());
            return object;
        }
        if (this.positions.get(0) != 0) {
            int[] nArray = this.getPositions();
            object = nArray;
            int[] nArray2 = new int[nArray.length];
            for (int i2 = 0; i2 < ((Object)object).length; ++i2) {
                nArray2[i2] = (int)(object[i2] - object[0]);
            }
            PhraseQuery phraseQuery = new PhraseQuery(this.slop, this.getTerms(), nArray2);
            phraseQuery.setBoost(this.getBoost());
            return phraseQuery;
        }
        return super.rewrite((IndexReader)object);
    }

    @Override
    public Weight createWeight(IndexSearcher indexSearcher, boolean bl) throws IOException {
        return new PhraseWeight(indexSearcher, bl);
    }

    @Override
    public String toString(String string) {
        int n2;
        Term[] termArray = this.getTerms();
        int[] nArray = this.getPositions();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.field != null && !this.field.equals(string)) {
            stringBuilder.append(this.field);
            stringBuilder.append(":");
        }
        stringBuilder.append("\"");
        int n3 = nArray.length == 0 ? -1 : nArray[nArray.length - 1];
        String[] stringArray = new String[n3 + 1];
        for (n2 = 0; n2 < termArray.length; ++n2) {
            int n4 = nArray[n2];
            String string2 = stringArray[n4];
            string2 = string2 == null ? termArray[n2].text() : string2 + "|" + termArray[n2].text();
            stringArray[n4] = string2;
        }
        for (n2 = 0; n2 < stringArray.length; ++n2) {
            String string3;
            if (n2 > 0) {
                stringBuilder.append(' ');
            }
            if ((string3 = stringArray[n2]) == null) {
                stringBuilder.append('?');
                continue;
            }
            stringBuilder.append(string3);
        }
        stringBuilder.append("\"");
        if (this.slop != 0) {
            stringBuilder.append("~");
            stringBuilder.append(this.slop);
        }
        stringBuilder.append(ToStringUtils.boost(this.getBoost()));
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        object = (PhraseQuery)object;
        return this.slop == ((PhraseQuery)object).slop && this.terms.equals(((PhraseQuery)object).terms) && this.positions.equals(((PhraseQuery)object).positions);
    }

    @Override
    public int hashCode() {
        return ((super.hashCode() * 31 + this.slop) * 31 + this.terms.hashCode()) * 31 + this.positions.hashCode();
    }

    @Deprecated
    public PhraseQuery() {
        this.terms = new ArrayList<Term>();
        this.positions = new ArrayList<Integer>();
        this.mutable = true;
    }

    private class PhraseWeight
    extends Weight {
        private final a similarity;
        private final a.b stats;
        private final boolean needsScores;
        private transient TermContext[] states;
        private final Term[] terms;
        private final int[] positions;

        public PhraseWeight(IndexSearcher indexSearcher, boolean bl) throws IOException {
            super(PhraseQuery.this);
            this.terms = PhraseQuery.this.getTerms();
            this.positions = PhraseQuery.this.getPositions();
            Object[] objectArray = PhraseQuery.this.getPositions();
            if (objectArray.length < 2) {
                throw new IllegalStateException("PhraseWeight does not support less than 2 terms, call rewrite first");
            }
            if (objectArray[0] != 0) {
                throw new IllegalStateException("PhraseWeight requires that the first position is 0, call rewrite first");
            }
            this.needsScores = bl;
            this.similarity = indexSearcher.getSimilarity(bl);
            IndexReaderContext indexReaderContext = indexSearcher.getTopReaderContext();
            this.states = new TermContext[this.terms.length];
            objectArray = new TermStatistics[this.terms.length];
            for (int i2 = 0; i2 < this.terms.length; ++i2) {
                Term term = this.terms[i2];
                this.states[i2] = TermContext.build(indexReaderContext, term);
                objectArray[i2] = (int)indexSearcher.termStatistics(term, this.states[i2]);
            }
            this.stats = this.similarity.computeWeight(PhraseQuery.this.getBoost(), indexSearcher.collectionStatistics(PhraseQuery.this.field), (TermStatistics[])objectArray);
        }

        public String toString() {
            return "weight(" + PhraseQuery.this + ")";
        }

        @Override
        public float getValueForNormalization() {
            return this.stats.getValueForNormalization();
        }

        @Override
        public void normalize(float f2, float f3) {
            this.stats.normalize(f2, f3);
        }

        @Override
        public Scorer scorer(LeafReaderContext leafReaderContext) throws IOException {
            assert (this.terms.length > 0);
            LeafReader leafReader = leafReaderContext.reader();
            Comparable[] comparableArray = new PostingsAndFreq[this.terms.length];
            Object object = leafReader.terms(PhraseQuery.this.field);
            if (object == null) {
                return null;
            }
            if (!((Terms)object).hasPositions()) {
                throw new IllegalStateException("field \"" + PhraseQuery.this.field + "\" was indexed without position data; cannot run PhraseQuery (phrase=" + this.getQuery() + ")");
            }
            object = ((Terms)object).iterator();
            for (int i2 = 0; i2 < this.terms.length; ++i2) {
                Term term = this.terms[i2];
                Object object2 = this.states[i2].get(leafReaderContext.ord);
                if (object2 == null) {
                    assert (this.termNotInReader(leafReader, term)) : "no termstate found but term exists in reader";
                    return null;
                }
                ((TermsEnum)object).seekExact(term.bytes(), (q)object2);
                object2 = ((TermsEnum)object).postings(null, 24);
                comparableArray[i2] = new PostingsAndFreq((PostingsEnum)object2, this.positions[i2], term);
            }
            if (PhraseQuery.this.slop == 0) {
                ArrayUtil.timSort((Comparable[])comparableArray);
            }
            if (PhraseQuery.this.slop == 0) {
                return new ExactPhraseScorer(this, (PostingsAndFreq[])comparableArray, this.similarity.simScorer(this.stats, leafReaderContext), this.needsScores);
            }
            return new SloppyPhraseScorer(this, (PostingsAndFreq[])comparableArray, PhraseQuery.this.slop, this.similarity.simScorer(this.stats, leafReaderContext), this.needsScores);
        }

        private boolean termNotInReader(LeafReader leafReader, Term term) throws IOException {
            return leafReader.docFreq(term) == 0;
        }
    }

    static class PostingsAndFreq
    implements Comparable<PostingsAndFreq> {
        final PostingsEnum postings;
        final int position;
        final Term[] terms;
        final int nTerms;

        public PostingsAndFreq(PostingsEnum objectArray, int n2, Term ... termArray) {
            this.postings = objectArray;
            this.position = n2;
            int n3 = this.nTerms = termArray == null ? 0 : termArray.length;
            if (this.nTerms > 0) {
                if (termArray.length == 1) {
                    this.terms = termArray;
                    return;
                }
                objectArray = new Term[termArray.length];
                System.arraycopy(termArray, 0, objectArray, 0, termArray.length);
                Arrays.sort(objectArray);
                this.terms = objectArray;
                return;
            }
            this.terms = null;
        }

        @Override
        public int compareTo(PostingsAndFreq postingsAndFreq) {
            if (this.position != postingsAndFreq.position) {
                return this.position - postingsAndFreq.position;
            }
            if (this.nTerms != postingsAndFreq.nTerms) {
                return this.nTerms - postingsAndFreq.nTerms;
            }
            if (this.nTerms == 0) {
                return 0;
            }
            for (int i2 = 0; i2 < this.terms.length; ++i2) {
                int n2 = this.terms[i2].compareTo(postingsAndFreq.terms[i2]);
                if (n2 == 0) continue;
                return n2;
            }
            return 0;
        }

        public int hashCode() {
            int n2 = 31 + this.position;
            for (int i2 = 0; i2 < this.nTerms; ++i2) {
                n2 = n2 * 31 + this.terms[i2].hashCode();
            }
            return n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null) {
                return false;
            }
            if (this.getClass() != object.getClass()) {
                return false;
            }
            object = (PostingsAndFreq)object;
            if (this.position != ((PostingsAndFreq)object).position) {
                return false;
            }
            if (this.terms == null) {
                return ((PostingsAndFreq)object).terms == null;
            }
            return Arrays.equals(this.terms, ((PostingsAndFreq)object).terms);
        }
    }

    public static class Builder {
        private int slop = 0;
        private final List<Term> terms = new ArrayList<Term>();
        private final List<Integer> positions = new ArrayList<Integer>();

        public Builder setSlop(int n2) {
            this.slop = n2;
            return this;
        }

        public Builder add(Term term) {
            return this.add(term, this.positions.isEmpty() ? 0 : 1 + this.positions.get(this.positions.size() - 1));
        }

        public Builder add(Term term, int n2) {
            int n3;
            term = new Term(term.field(), BytesRef.deepCopyOf(term.bytes()));
            if (n2 < 0) {
                throw new IllegalArgumentException("Positions must be >= 0, got " + n2);
            }
            if (!this.positions.isEmpty() && n2 < (n3 = this.positions.get(this.positions.size() - 1).intValue())) {
                throw new IllegalArgumentException("Positions must be added in order, got " + n2 + " after " + n3);
            }
            if (!this.terms.isEmpty() && !term.field().equals(this.terms.get(0).field())) {
                throw new IllegalArgumentException("All terms must be on the same field, got " + term.field() + " and " + this.terms.get(0).field());
            }
            this.terms.add(term);
            this.positions.add(n2);
            return this;
        }

        public PhraseQuery build() {
            Term[] termArray = this.terms.toArray(new Term[this.terms.size()]);
            int[] nArray = new int[this.positions.size()];
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                nArray[i2] = this.positions.get(i2);
            }
            return new PhraseQuery(this.slop, termArray, nArray);
        }
    }
}

