/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.PostingsEnum;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.q;
import org.apache.lucene.portmobile.util.Objects;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreQuery;
import org.apache.lucene.search.ConstantScoreScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.DocIdSet;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MultiTermQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.TermQuery;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.DocIdSetBuilder;

final class MultiTermQueryConstantScoreWrapper<Q extends MultiTermQuery>
extends Query {
    protected final Q query;

    protected MultiTermQueryConstantScoreWrapper(Q q2) {
        this.query = q2;
    }

    @Override
    public final String toString(String string) {
        return ((Query)this.query).toString(string);
    }

    @Override
    public final boolean equals(Object object) {
        if (!super.equals(object)) {
            return false;
        }
        object = (MultiTermQueryConstantScoreWrapper)object;
        return ((MultiTermQuery)this.query).equals(((MultiTermQueryConstantScoreWrapper)object).query) && this.getBoost() == ((Query)object).getBoost();
    }

    @Override
    public final int hashCode() {
        return 31 * super.hashCode() + ((MultiTermQuery)this.query).hashCode();
    }

    @Override
    public final Weight createWeight(final IndexSearcher indexSearcher, final boolean bl) throws IOException {
        return new ConstantScoreWeight(this){

            private boolean collectTerms(LeafReaderContext leafReaderContext, TermsEnum termsEnum, List<TermAndState> list) throws IOException {
                int n2 = Math.min(16, BooleanQuery.getMaxClauseCount());
                for (int i2 = 0; i2 < n2; ++i2) {
                    BytesRef bytesRef = termsEnum.next();
                    if (bytesRef == null) {
                        return true;
                    }
                    q q2 = termsEnum.termState();
                    if (!q2.isRealTerm()) {
                        return false;
                    }
                    list.add(new TermAndState(BytesRef.deepCopyOf(bytesRef), q2, termsEnum.docFreq(), termsEnum.totalTermFreq()));
                }
                return termsEnum.next() == null;
            }

            private WeightOrDocIdSet rewrite(LeafReaderContext leafReaderContext) throws IOException {
                Object object = leafReaderContext.reader().terms(((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).field);
                if (object == null) {
                    return new WeightOrDocIdSet(null);
                }
                TermsEnum termsEnum = ((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).getTermsEnum((Terms)object);
                assert (termsEnum != null);
                PostingsEnum postingsEnum = null;
                Object object2 = new ArrayList<TermAndState>();
                if (this.collectTerms(leafReaderContext, termsEnum, (List<TermAndState>)object2)) {
                    BooleanQuery.Builder builder = new BooleanQuery.Builder();
                    object = object2.iterator();
                    while (object.hasNext()) {
                        object2 = (TermAndState)object.next();
                        TermContext termContext = new TermContext(indexSearcher.getTopReaderContext());
                        termContext.register(((TermAndState)object2).state, leafReaderContext.ord, ((TermAndState)object2).docFreq, ((TermAndState)object2).totalTermFreq);
                        builder.add(new TermQuery(new Term(((MultiTermQuery)MultiTermQueryConstantScoreWrapper.this.query).field, ((TermAndState)object2).term), termContext), BooleanClause.Occur.SHOULD);
                    }
                    object = new ConstantScoreQuery(builder.build());
                    ((Query)object).setBoost(this.score());
                    return new WeightOrDocIdSet(indexSearcher.rewrite((Query)object).createWeight(indexSearcher, bl));
                }
                DocIdSetBuilder docIdSetBuilder = new DocIdSetBuilder(leafReaderContext.reader().maxDoc());
                if (!object2.isEmpty()) {
                    object = ((Terms)object).iterator();
                    object2 = object2.iterator();
                    while (object2.hasNext()) {
                        TermAndState termAndState = (TermAndState)object2.next();
                        ((TermsEnum)object).seekExact(termAndState.term, termAndState.state);
                        postingsEnum = ((TermsEnum)object).postings(postingsEnum, 0);
                        docIdSetBuilder.add(postingsEnum);
                    }
                }
                do {
                    postingsEnum = termsEnum.postings(postingsEnum, 0);
                    docIdSetBuilder.add(postingsEnum);
                } while (termsEnum.next() != null);
                return new WeightOrDocIdSet(docIdSetBuilder.build());
            }

            private Scorer scorer(DocIdSet object) throws IOException {
                if (object == null) {
                    return null;
                }
                if ((object = ((DocIdSet)object).iterator()) == null) {
                    return null;
                }
                return new ConstantScoreScorer((Weight)this, this.score(), (DocIdSetIterator)object);
            }

            @Override
            public BulkScorer bulkScorer(LeafReaderContext object) throws IOException {
                WeightOrDocIdSet weightOrDocIdSet = this.rewrite((LeafReaderContext)object);
                if (weightOrDocIdSet.weight != null) {
                    return weightOrDocIdSet.weight.bulkScorer((LeafReaderContext)object);
                }
                object = this.scorer(weightOrDocIdSet.set);
                if (object == null) {
                    return null;
                }
                return new Weight.DefaultBulkScorer((Scorer)object);
            }

            @Override
            public Scorer scorer(LeafReaderContext leafReaderContext) throws IOException {
                WeightOrDocIdSet weightOrDocIdSet = this.rewrite(leafReaderContext);
                if (weightOrDocIdSet.weight != null) {
                    return weightOrDocIdSet.weight.scorer(leafReaderContext);
                }
                return this.scorer(weightOrDocIdSet.set);
            }
        };
    }

    private static class WeightOrDocIdSet {
        final Weight weight;
        final DocIdSet set;

        WeightOrDocIdSet(Weight weight) {
            this.weight = Objects.requireNonNull(weight);
            this.set = null;
        }

        WeightOrDocIdSet(DocIdSet docIdSet) {
            this.set = docIdSet;
            this.weight = null;
        }
    }

    private static class TermAndState {
        final BytesRef term;
        final q state;
        final int docFreq;
        final long totalTermFreq;

        TermAndState(BytesRef bytesRef, q q2, int n2, long l2) {
            this.term = bytesRef;
            this.state = q2;
            this.docFreq = n2;
            this.totalTermFreq = l2;
        }
    }
}

