/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.portmobile.util.Objects;
import org.apache.lucene.search.MultiTermQueryConstantScoreWrapper;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ScoringRewrite;
import org.apache.lucene.util.AttributeSource;

public abstract class MultiTermQuery
extends Query {
    protected final String field;
    protected a rewriteMethod = CONSTANT_SCORE_REWRITE;
    public static final a CONSTANT_SCORE_REWRITE;
    @Deprecated
    public static final a CONSTANT_SCORE_FILTER_REWRITE;
    public static final a SCORING_BOOLEAN_REWRITE;
    @Deprecated
    public static final a SCORING_BOOLEAN_QUERY_REWRITE;
    public static final a CONSTANT_SCORE_BOOLEAN_REWRITE;
    @Deprecated
    public static final a CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE;

    public MultiTermQuery(String string) {
        this.field = Objects.requireNonNull(string, "field must not be null");
    }

    public final String getField() {
        return this.field;
    }

    protected abstract TermsEnum getTermsEnum(Terms var1, AttributeSource var2) throws IOException;

    protected final TermsEnum getTermsEnum(Terms terms) throws IOException {
        return this.getTermsEnum(terms, new AttributeSource());
    }

    @Override
    public final Query rewrite(IndexReader indexReader) throws IOException {
        return this.rewriteMethod.rewrite(indexReader, this);
    }

    @Override
    public int hashCode() {
        int n2 = (31 + Float.floatToIntBits(this.getBoost())) * 31 + this.rewriteMethod.hashCode();
        if (this.field != null) {
            n2 = n2 * 31 + this.field.hashCode();
        }
        return n2;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        MultiTermQuery multiTermQuery = (MultiTermQuery)object;
        if (!super.equals(object)) {
            return false;
        }
        if (!this.rewriteMethod.equals(multiTermQuery.rewriteMethod)) {
            return false;
        }
        if (multiTermQuery.field == null) {
            return this.field == null;
        }
        return multiTermQuery.field.equals(this.field);
    }

    static {
        CONSTANT_SCORE_FILTER_REWRITE = CONSTANT_SCORE_REWRITE = new a(){

            @Override
            public final Query rewrite(IndexReader object, MultiTermQuery multiTermQuery) {
                object = new MultiTermQueryConstantScoreWrapper<MultiTermQuery>(multiTermQuery);
                ((Query)object).setBoost(multiTermQuery.getBoost());
                return object;
            }
        };
        SCORING_BOOLEAN_QUERY_REWRITE = SCORING_BOOLEAN_REWRITE = ScoringRewrite.SCORING_BOOLEAN_REWRITE;
        CONSTANT_SCORE_BOOLEAN_QUERY_REWRITE = CONSTANT_SCORE_BOOLEAN_REWRITE = ScoringRewrite.CONSTANT_SCORE_BOOLEAN_REWRITE;
    }

    public static abstract class a {
        public abstract Query rewrite(IndexReader var1, MultiTermQuery var2) throws IOException;

        protected TermsEnum getTermsEnum(MultiTermQuery multiTermQuery, Terms terms, AttributeSource attributeSource) throws IOException {
            return multiTermQuery.getTermsEnum(terms, attributeSource);
        }
    }
}

