/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.ScoreCachingWrappingScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.c;
import org.apache.lucene.search.g;

public class MultiCollector
implements c {
    private final boolean cacheScores;
    private final c[] collectors;

    public static c wrap(c ... cArray) {
        return MultiCollector.wrap(Arrays.asList(cArray));
    }

    public static c wrap(Iterable<? extends c> object) {
        int n2 = 0;
        Object object2 = object.iterator();
        while (object2.hasNext()) {
            if (object2.next() == null) continue;
            ++n2;
        }
        if (n2 == 0) {
            throw new IllegalArgumentException("At least 1 collector must not be null");
        }
        if (n2 == 1) {
            object2 = null;
            Iterator<? extends c> iterator = object.iterator();
            while (iterator.hasNext()) {
                object = iterator.next();
                if (object == null) continue;
                object2 = object;
                break;
            }
            return object2;
        }
        object2 = new c[n2];
        n2 = 0;
        Iterator<? extends c> iterator = object.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            if (object == null) continue;
            object2[n2++] = object;
        }
        return new MultiCollector((c)object2);
    }

    private MultiCollector(c ... cArray) {
        this.collectors = cArray;
        int n2 = 0;
        int n3 = cArray.length;
        for (int i2 = 0; i2 < n3; ++i2) {
            if (!cArray[i2].needsScores()) continue;
            ++n2;
        }
        this.cacheScores = n2 >= 2;
    }

    @Override
    public boolean needsScores() {
        c[] cArray = this.collectors;
        int n2 = this.collectors.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            if (!cArray[i2].needsScores()) continue;
            return true;
        }
        return false;
    }

    @Override
    public g getLeafCollector(LeafReaderContext leafReaderContext) throws IOException {
        g[] gArray = new g[this.collectors.length];
        for (int i2 = 0; i2 < this.collectors.length; ++i2) {
            gArray[i2] = this.collectors[i2].getLeafCollector(leafReaderContext);
        }
        return new MultiLeafCollector(gArray, this.cacheScores);
    }

    private static class MultiLeafCollector
    implements g {
        private final boolean cacheScores;
        private final g[] collectors;

        private MultiLeafCollector(g[] gArray, boolean bl) {
            this.collectors = gArray;
            this.cacheScores = bl;
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            if (this.cacheScores) {
                scorer = new ScoreCachingWrappingScorer(scorer);
            }
            g[] gArray = this.collectors;
            int n2 = this.collectors.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                gArray[i2].setScorer(scorer);
            }
        }

        @Override
        public void collect(int n2) throws IOException {
            g[] gArray = this.collectors;
            int n3 = this.collectors.length;
            for (int i2 = 0; i2 < n3; ++i2) {
                gArray[i2].collect(n2);
            }
        }
    }
}

