/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import org.apache.lucene.search.DisiPriorityQueue;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.util.PriorityQueue;

final class MinShouldMatchSumScorer
extends Scorer {
    final int minShouldMatch;
    final float[] coord;
    DisiWrapper<Scorer> lead;
    int doc;
    int freq;
    final DisiPriorityQueue<Scorer> head;
    final DisiWrapper<Scorer>[] tail;
    int tailSize;
    final Collection<Scorer.ChildScorer> childScorers;
    final long cost;

    private static long cost(Collection<Scorer> object, int n2) {
        PriorityQueue<Scorer> priorityQueue = new PriorityQueue<Scorer>(object.size() - n2 + 1){

            @Override
            protected final /* synthetic */ boolean lessThan(Object object, Object object2) {
                object2 = (Scorer)object2;
                return ((Scorer)object).cost() > ((DocIdSetIterator)object2).cost();
            }
        };
        Iterator<Scorer> iterator = object.iterator();
        while (iterator.hasNext()) {
            Scorer scorer = iterator.next();
            priorityQueue.insertWithOverflow(scorer);
        }
        long l2 = 0L;
        object = (Scorer)priorityQueue.pop();
        while (object != null) {
            l2 += ((DocIdSetIterator)object).cost();
            object = (Scorer)priorityQueue.pop();
        }
        return l2;
    }

    MinShouldMatchSumScorer(Weight arrayList, Collection<Scorer> collection, int n2, float[] object) {
        super((Weight)((Object)arrayList));
        if (n2 > collection.size()) {
            throw new IllegalArgumentException("minShouldMatch should be <= the number of scorers");
        }
        if (n2 <= 0) {
            throw new IllegalArgumentException("minShouldMatch should be >= 1");
        }
        this.minShouldMatch = n2;
        this.coord = object;
        this.doc = -1;
        this.head = new DisiPriorityQueue(collection.size() - n2 + 1);
        this.tail = new DisiWrapper[n2 - 1];
        arrayList = collection.iterator();
        while (arrayList.hasNext()) {
            object = (Scorer)arrayList.next();
            this.addLead(new DisiWrapper<float[]>((float[])object));
        }
        arrayList = new ArrayList<Scorer.ChildScorer>();
        object = collection.iterator();
        while (object.hasNext()) {
            Scorer scorer = (Scorer)object.next();
            arrayList.add(new Scorer.ChildScorer(scorer, "SHOULD"));
        }
        this.childScorers = Collections.unmodifiableCollection(arrayList);
        this.cost = MinShouldMatchSumScorer.cost(collection, n2);
    }

    @Override
    public final long cost() {
        return this.cost;
    }

    @Override
    public final int nextDoc() throws IOException {
        DisiWrapper<Scorer> disiWrapper = this.lead;
        while (disiWrapper != null) {
            DisiWrapper<Scorer> disiWrapper2 = this.insertTailWithOverFlow(disiWrapper);
            if (disiWrapper2 != null) {
                disiWrapper2.doc = disiWrapper2.doc == this.doc ? ((Scorer)disiWrapper2.iterator).nextDoc() : ((Scorer)disiWrapper2.iterator).advance(this.doc + 1);
                this.head.add(disiWrapper2);
            }
            disiWrapper = disiWrapper.next;
        }
        this.setDocAndFreq();
        return this.doNext();
    }

    @Override
    public final int advance(int n2) throws IOException {
        DisiWrapper<Scorer> disiWrapper;
        DisiWrapper<Scorer> disiWrapper2 = this.lead;
        while (disiWrapper2 != null) {
            disiWrapper = this.insertTailWithOverFlow(disiWrapper2);
            if (disiWrapper != null) {
                disiWrapper.doc = ((Scorer)disiWrapper.iterator).advance(n2);
                this.head.add(disiWrapper);
            }
            disiWrapper2 = disiWrapper2.next;
        }
        disiWrapper2 = this.head.top();
        while (disiWrapper2.doc < n2) {
            disiWrapper = this.insertTailWithOverFlow(disiWrapper2);
            disiWrapper.doc = ((Scorer)disiWrapper.iterator).advance(n2);
            disiWrapper2 = this.head.updateTop(disiWrapper);
        }
        this.setDocAndFreq();
        return this.doNext();
    }

    private void addLead(DisiWrapper<Scorer> disiWrapper) {
        disiWrapper.next = this.lead;
        this.lead = disiWrapper;
        ++this.freq;
    }

    private void pushBackLeads() throws IOException {
        DisiWrapper<Scorer> disiWrapper = this.lead;
        while (disiWrapper != null) {
            this.addTail(disiWrapper);
            disiWrapper = disiWrapper.next;
        }
    }

    private void advanceTail(DisiWrapper<Scorer> disiWrapper) throws IOException {
        disiWrapper.doc = ((Scorer)disiWrapper.iterator).advance(this.doc);
        if (disiWrapper.doc == this.doc) {
            this.addLead(disiWrapper);
            return;
        }
        this.head.add(disiWrapper);
    }

    private void advanceTail() throws IOException {
        DisiWrapper<Scorer> disiWrapper = this.popTail();
        this.advanceTail(disiWrapper);
    }

    private void setDocAndFreq() {
        assert (this.head.size() > 0);
        this.lead = this.head.pop();
        this.lead.next = null;
        this.freq = 1;
        this.doc = this.lead.doc;
        while (this.head.size() > 0 && this.head.top().doc == this.doc) {
            this.addLead(this.head.pop());
        }
    }

    private int doNext() throws IOException {
        while (this.freq < this.minShouldMatch) {
            assert (this.freq > 0);
            if (this.freq + this.tailSize >= this.minShouldMatch) {
                this.advanceTail();
                continue;
            }
            this.pushBackLeads();
            this.setDocAndFreq();
        }
        return this.doc;
    }

    private void updateFreq() throws IOException {
        assert (this.freq >= this.minShouldMatch);
        for (int i2 = this.tailSize - 1; i2 >= 0; --i2) {
            this.advanceTail(this.tail[i2]);
        }
        this.tailSize = 0;
    }

    @Override
    public final int freq() throws IOException {
        this.updateFreq();
        return this.freq;
    }

    @Override
    public final float score() throws IOException {
        this.updateFreq();
        double d2 = 0.0;
        DisiWrapper<Scorer> disiWrapper = this.lead;
        while (disiWrapper != null) {
            d2 += (double)((Scorer)disiWrapper.iterator).score();
            disiWrapper = disiWrapper.next;
        }
        return this.coord[this.freq] * (float)d2;
    }

    @Override
    public final int docID() {
        assert (this.doc == this.lead.doc);
        return this.doc;
    }

    private DisiWrapper<Scorer> insertTailWithOverFlow(DisiWrapper<Scorer> disiWrapper) {
        if (this.tailSize < this.tail.length) {
            this.addTail(disiWrapper);
            return null;
        }
        if (this.tail.length > 0) {
            DisiWrapper<Scorer> disiWrapper2 = this.tail[0];
            if (disiWrapper2.cost < disiWrapper.cost) {
                this.tail[0] = disiWrapper;
                MinShouldMatchSumScorer.downHeapCost(this.tail, this.tailSize);
                return disiWrapper2;
            }
        }
        return disiWrapper;
    }

    private void addTail(DisiWrapper<Scorer> disiWrapper) {
        this.tail[this.tailSize] = disiWrapper;
        MinShouldMatchSumScorer.upHeapCost(this.tail, this.tailSize);
        ++this.tailSize;
    }

    private DisiWrapper<Scorer> popTail() {
        assert (this.tailSize > 0);
        DisiWrapper<Scorer> disiWrapper = this.tail[0];
        this.tail[0] = this.tail[--this.tailSize];
        MinShouldMatchSumScorer.downHeapCost(this.tail, this.tailSize);
        return disiWrapper;
    }

    private static void upHeapCost(DisiWrapper<Scorer>[] disiWrapperArray, int n2) {
        DisiWrapper<Scorer> disiWrapper = disiWrapperArray[n2];
        long l2 = disiWrapper.cost;
        int n3 = DisiPriorityQueue.parentNode(n2);
        while (n3 >= 0 && l2 < disiWrapperArray[n3].cost) {
            disiWrapperArray[n2] = disiWrapperArray[n3];
            n2 = n3;
            n3 = DisiPriorityQueue.parentNode(n3);
        }
        disiWrapperArray[n2] = disiWrapper;
    }

    private static void downHeapCost(DisiWrapper<Scorer>[] disiWrapperArray, int n2) {
        int n3 = 0;
        DisiWrapper<Scorer> disiWrapper = disiWrapperArray[0];
        int n4 = DisiPriorityQueue.leftNode(0);
        if (n4 < n2) {
            int n5 = DisiPriorityQueue.rightNode(n4);
            if (n5 < n2 && disiWrapperArray[n5].cost < disiWrapperArray[n4].cost) {
                n4 = n5;
            }
            if (disiWrapperArray[n4].cost < disiWrapper.cost) {
                do {
                    disiWrapperArray[n3] = disiWrapperArray[n4];
                    n3 = n4;
                    n5 = DisiPriorityQueue.rightNode(n4 = DisiPriorityQueue.leftNode(n3));
                    if (n5 >= n2 || disiWrapperArray[n5].cost >= disiWrapperArray[n4].cost) continue;
                    n4 = n5;
                } while (n4 < n2 && disiWrapperArray[n4].cost < disiWrapper.cost);
                disiWrapperArray[n3] = disiWrapper;
            }
        }
    }
}

