/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import org.apache.lucene.document.Document;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.MultiFields;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.TermContext;
import org.apache.lucene.index.Terms;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.CollectionStatistics;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.Sort;
import org.apache.lucene.search.TermStatistics;
import org.apache.lucene.search.TopDocs;
import org.apache.lucene.search.TopFieldCollector;
import org.apache.lucene.search.TopFieldDocs;
import org.apache.lucene.search.TopScoreDocCollector;
import org.apache.lucene.search.UsageTrackingQueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.b;
import org.apache.lucene.search.c;
import org.apache.lucene.search.d;
import org.apache.lucene.search.g;
import org.apache.lucene.search.l;
import org.apache.lucene.search.similarities.DefaultSimilarity;
import org.apache.lucene.search.similarities.a;
import org.apache.lucene.util.j;

public class IndexSearcher {
    private static final a NON_SCORING_SIMILARITY = new a(){

        @Override
        public final long computeNorm(FieldInvertState fieldInvertState) {
            throw new UnsupportedOperationException("This Similarity may only be used for searching, not indexing");
        }

        @Override
        public final a.b computeWeight(float f2, CollectionStatistics collectionStatistics, TermStatistics ... termStatisticsArray) {
            return new a.b(){

                @Override
                public float getValueForNormalization() {
                    return 1.0f;
                }

                @Override
                public void normalize(float f2, float f3) {
                }
            };
        }

        @Override
        public final a.a simScorer(a.b b2, LeafReaderContext leafReaderContext) throws IOException {
            return new a.a(){

                @Override
                public float score(int n2, float f2) {
                    return 0.0f;
                }

                @Override
                public float computeSlopFactor(int n2) {
                    return 1.0f;
                }
            };
        }
    };
    private static l DEFAULT_QUERY_CACHE = null;
    private static QueryCachingPolicy DEFAULT_CACHING_POLICY = new UsageTrackingQueryCachingPolicy();
    final IndexReader reader;
    protected final IndexReaderContext readerContext;
    protected final List<LeafReaderContext> leafContexts;
    protected final LeafSlice[] leafSlices;
    private final ExecutorService executor;
    private static final a defaultSimilarity = new DefaultSimilarity();
    private l queryCache = DEFAULT_QUERY_CACHE;
    private QueryCachingPolicy queryCachingPolicy = DEFAULT_CACHING_POLICY;
    private a similarity = defaultSimilarity;

    public static a getDefaultSimilarity() {
        return defaultSimilarity;
    }

    public IndexSearcher(IndexReader indexReader) {
        this(indexReader, null);
    }

    public IndexSearcher(IndexReader indexReader, ExecutorService executorService) {
        this(indexReader.getContext(), executorService);
    }

    public IndexSearcher(IndexReaderContext indexReaderContext, ExecutorService executorService) {
        assert (indexReaderContext.isTopLevel) : "IndexSearcher's ReaderContext must be topLevel for reader" + indexReaderContext.reader();
        this.reader = indexReaderContext.reader();
        this.executor = executorService;
        this.readerContext = indexReaderContext;
        this.leafContexts = indexReaderContext.leaves();
        this.leafSlices = executorService == null ? null : this.slices(this.leafContexts);
    }

    public void setQueryCache(l l2) {
        this.queryCache = l2;
    }

    protected LeafSlice[] slices(List<LeafReaderContext> list) {
        LeafSlice[] leafSliceArray = new LeafSlice[list.size()];
        for (int i2 = 0; i2 < leafSliceArray.length; ++i2) {
            leafSliceArray[i2] = new LeafSlice(list.get(i2));
        }
        return leafSliceArray;
    }

    public IndexReader getIndexReader() {
        return this.reader;
    }

    public Document doc(int n2) throws IOException {
        return this.reader.document(n2);
    }

    public a getSimilarity(boolean bl) {
        if (bl) {
            return this.similarity;
        }
        return NON_SCORING_SIMILARITY;
    }

    public TopDocs searchAfter(ScoreDoc object, Query query, final int n2) throws IOException {
        int n3 = Math.max(1, this.reader.maxDoc());
        if (object != null && ((ScoreDoc)object).doc >= n3) {
            throw new IllegalArgumentException("after.doc exceeds the number of documents in the reader: after.doc=" + ((ScoreDoc)object).doc + " limit=" + n3);
        }
        n2 = Math.min(Math.min(n2, n3), n3);
        object = new d<TopScoreDocCollector, TopDocs>((ScoreDoc)object){
            final /* synthetic */ ScoreDoc val$after;
            {
                this.val$after = scoreDoc;
            }

            @Override
            public TopScoreDocCollector newCollector() throws IOException {
                return TopScoreDocCollector.create(n2, this.val$after);
            }

            @Override
            public TopDocs reduce(Collection<TopScoreDocCollector> object) throws IOException {
                TopDocs[] topDocsArray = new TopDocs[object.size()];
                int n22 = 0;
                object = object.iterator();
                while (object.hasNext()) {
                    TopScoreDocCollector topScoreDocCollector = (TopScoreDocCollector)object.next();
                    topDocsArray[n22++] = topScoreDocCollector.topDocs();
                }
                return TopDocs.merge(n2, topDocsArray);
            }
        };
        return (TopDocs)this.search(query, (d)object);
    }

    public TopDocs search(Query query, int n2) throws IOException {
        return this.searchAfter(null, query, n2);
    }

    public void search(Query query, c c2) throws IOException {
        this.search(this.leafContexts, this.createNormalizedWeight(query, c2.needsScores()), c2);
    }

    public final TopFieldDocs search(Query query, int n2, Sort sort, boolean bl, boolean bl2) throws IOException {
        return this.searchAfter(null, query, n2, sort, bl, bl2);
    }

    public final TopFieldDocs searchAfter(ScoreDoc scoreDoc, Query query, int n2, Sort sort, boolean bl, boolean bl2) throws IOException {
        if (scoreDoc != null && !(scoreDoc instanceof FieldDoc)) {
            throw new IllegalArgumentException("after must be a FieldDoc; got " + scoreDoc);
        }
        return this.searchAfter((FieldDoc)scoreDoc, query, n2, sort, bl, bl2);
    }

    private TopFieldDocs searchAfter(FieldDoc object, Query query, final int n2, final Sort sort, boolean bl, boolean bl2) throws IOException {
        int n3 = Math.max(1, this.reader.maxDoc());
        if (object != null && ((FieldDoc)object).doc >= n3) {
            throw new IllegalArgumentException("after.doc exceeds the number of documents in the reader: after.doc=" + ((FieldDoc)object).doc + " limit=" + n3);
        }
        n2 = Math.min(n2, n3);
        object = new d<TopFieldCollector, TopFieldDocs>((FieldDoc)object, bl, bl2){
            final /* synthetic */ FieldDoc val$after;
            final /* synthetic */ boolean val$doDocScores;
            final /* synthetic */ boolean val$doMaxScore;
            {
                this.val$after = fieldDoc;
                this.val$doDocScores = bl;
                this.val$doMaxScore = bl2;
            }

            @Override
            public TopFieldCollector newCollector() throws IOException {
                return TopFieldCollector.create(sort, n2, this.val$after, true, this.val$doDocScores, this.val$doMaxScore);
            }

            @Override
            public TopFieldDocs reduce(Collection<TopFieldCollector> object) throws IOException {
                TopFieldDocs[] topFieldDocsArray = new TopFieldDocs[object.size()];
                int n22 = 0;
                object = object.iterator();
                while (object.hasNext()) {
                    TopFieldCollector topFieldCollector = (TopFieldCollector)object.next();
                    topFieldDocsArray[n22++] = topFieldCollector.topDocs();
                }
                return TopDocs.merge(sort, n2, topFieldDocsArray);
            }
        };
        return (TopFieldDocs)this.search(query, (d)object);
    }

    public <C extends c, T> T search(Query query, d<C, T> d2) throws IOException {
        Object object;
        Object object2;
        if (this.executor == null) {
            C c2 = d2.newCollector();
            this.search(query, (c)c2);
            return d2.reduce(Collections.singletonList(c2));
        }
        ArrayList<C> arrayList = new ArrayList<C>(this.leafSlices.length);
        boolean bl = false;
        for (int i2 = 0; i2 < this.leafSlices.length; ++i2) {
            object2 = d2.newCollector();
            arrayList.add(object2);
            bl |= object2.needsScores();
        }
        final Weight weight = this.createNormalizedWeight(query, bl);
        object2 = new ArrayList(this.leafSlices.length);
        for (int i3 = 0; i3 < this.leafSlices.length; ++i3) {
            final LeafReaderContext[] leafReaderContextArray = this.leafSlices[i3].leaves;
            object = (c)arrayList.get(i3);
            object2.add(this.executor.submit(new Callable<C>((c)object){
                final /* synthetic */ c val$collector;
                {
                    this.val$collector = c2;
                }

                @Override
                public C call() throws Exception {
                    IndexSearcher.this.search(Arrays.asList(leafReaderContextArray), weight, this.val$collector);
                    return this.val$collector;
                }
            }));
        }
        ArrayList arrayList2 = new ArrayList();
        Iterator iterator = object2.iterator();
        while (iterator.hasNext()) {
            object = (Future)iterator.next();
            try {
                arrayList2.add(object.get());
            }
            catch (InterruptedException interruptedException) {
                throw new j(interruptedException);
            }
            catch (ExecutionException executionException) {
                throw new RuntimeException(executionException);
            }
        }
        return d2.reduce(arrayList);
    }

    protected void search(List<LeafReaderContext> object, Weight weight, c c2) throws IOException {
        object = object.iterator();
        while (object.hasNext()) {
            g g2;
            LeafReaderContext leafReaderContext = (LeafReaderContext)object.next();
            try {
                g2 = c2.getLeafCollector(leafReaderContext);
            }
            catch (b b2) {
                continue;
            }
            BulkScorer bulkScorer = weight.bulkScorer(leafReaderContext);
            if (bulkScorer == null) continue;
            try {
                bulkScorer.score(g2, leafReaderContext.reader().getLiveDocs());
            }
            catch (b b3) {}
        }
    }

    public Query rewrite(Query query) throws IOException {
        Query query2 = query.rewrite(this.reader);
        while (query2 != query) {
            query = query2;
            query2 = query.rewrite(this.reader);
        }
        return query;
    }

    public Weight createNormalizedWeight(Query object, boolean bl) throws IOException {
        object = this.rewrite((Query)object);
        object = this.createWeight((Query)object, bl);
        float f2 = ((Weight)object).getValueForNormalization();
        float f3 = this.getSimilarity(bl).queryNorm(f2);
        if (Float.isInfinite(f3) || Float.isNaN(f3)) {
            f3 = 1.0f;
        }
        ((Weight)object).normalize(f3, 1.0f);
        return object;
    }

    public Weight createWeight(Query object, boolean bl) throws IOException {
        l l2 = this.queryCache;
        object = ((Query)object).createWeight(this, bl);
        if (!bl && l2 != null) {
            object = l2.a();
        }
        return object;
    }

    public IndexReaderContext getTopReaderContext() {
        return this.readerContext;
    }

    public String toString() {
        return "IndexSearcher(" + this.reader + "; executor=" + this.executor + ")";
    }

    public TermStatistics termStatistics(Term term, TermContext termContext) throws IOException {
        return new TermStatistics(term.bytes(), termContext.docFreq(), termContext.totalTermFreq());
    }

    public CollectionStatistics collectionStatistics(String string) throws IOException {
        long l2;
        long l3;
        int n2;
        assert (string != null);
        Terms terms = MultiFields.getTerms(this.reader, string);
        if (terms == null) {
            n2 = 0;
            l3 = 0L;
            l2 = 0L;
        } else {
            n2 = terms.getDocCount();
            l3 = terms.getSumTotalTermFreq();
            l2 = terms.getSumDocFreq();
        }
        return new CollectionStatistics(string, this.reader.maxDoc(), n2, l3, l2);
    }

    public static class LeafSlice {
        final LeafReaderContext[] leaves;

        public LeafSlice(LeafReaderContext ... leafReaderContextArray) {
            this.leaves = leafReaderContextArray;
        }
    }
}

