/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.FieldDoc;
import org.apache.lucene.search.ScoreDoc;
import org.apache.lucene.search.SortField;
import org.apache.lucene.search.h;
import org.apache.lucene.util.PriorityQueue;

public abstract class FieldValueHitQueue<T extends Entry>
extends PriorityQueue<T> {
    protected final SortField[] fields;
    protected final FieldComparator<?>[] comparators;
    protected final int[] reverseMul;

    private FieldValueHitQueue(SortField[] sortFieldArray, int n2) throws IOException {
        super(n2);
        this.fields = sortFieldArray;
        int n3 = sortFieldArray.length;
        this.comparators = new FieldComparator[n3];
        this.reverseMul = new int[n3];
        for (int i2 = 0; i2 < n3; ++i2) {
            SortField sortField = sortFieldArray[i2];
            this.reverseMul[i2] = sortField.reverse ? -1 : 1;
            this.comparators[i2] = sortField.getComparator(n2, i2);
        }
    }

    public static <T extends Entry> FieldValueHitQueue<T> create(SortField[] sortFieldArray, int n2) throws IOException {
        if (sortFieldArray.length == 0) {
            throw new IllegalArgumentException("Sort must contain at least one field");
        }
        if (sortFieldArray.length == 1) {
            return new OneComparatorFieldValueHitQueue(sortFieldArray, n2);
        }
        return new MultiComparatorsFieldValueHitQueue(sortFieldArray, n2);
    }

    public int[] getReverseMul() {
        return this.reverseMul;
    }

    public h[] getComparators(LeafReaderContext leafReaderContext) throws IOException {
        h[] hArray = new h[this.comparators.length];
        for (int i2 = 0; i2 < hArray.length; ++i2) {
            hArray[i2] = this.comparators[i2].getLeafComparator(leafReaderContext);
        }
        return hArray;
    }

    @Override
    protected abstract boolean lessThan(Entry var1, Entry var2);

    FieldDoc fillFields(Entry entry) {
        int n2 = this.comparators.length;
        Object[] objectArray = new Object[n2];
        for (int i2 = 0; i2 < n2; ++i2) {
            objectArray[i2] = this.comparators[i2].value(entry.slot);
        }
        return new FieldDoc(entry.doc, entry.score, objectArray);
    }

    SortField[] getFields() {
        return this.fields;
    }

    private static final class MultiComparatorsFieldValueHitQueue<T extends Entry>
    extends FieldValueHitQueue<T> {
        public MultiComparatorsFieldValueHitQueue(SortField[] sortFieldArray, int n2) throws IOException {
            super(sortFieldArray, n2);
        }

        @Override
        protected final boolean lessThan(Entry entry, Entry entry2) {
            assert (entry != entry2);
            assert (entry.slot != entry2.slot);
            int n2 = this.comparators.length;
            for (int i2 = 0; i2 < n2; ++i2) {
                int n3 = this.reverseMul[i2] * this.comparators[i2].compare(entry.slot, entry2.slot);
                if (n3 == 0) continue;
                return n3 > 0;
            }
            return entry.doc > entry2.doc;
        }
    }

    private static final class OneComparatorFieldValueHitQueue<T extends Entry>
    extends FieldValueHitQueue<T> {
        private final int oneReverseMul;
        private final FieldComparator<?> oneComparator;

        public OneComparatorFieldValueHitQueue(SortField[] sortFieldArray, int n2) throws IOException {
            super(sortFieldArray, n2);
            assert (sortFieldArray.length == 1);
            this.oneComparator = this.comparators[0];
            this.oneReverseMul = this.reverseMul[0];
        }

        @Override
        protected final boolean lessThan(Entry entry, Entry entry2) {
            assert (entry != entry2);
            assert (entry.slot != entry2.slot);
            int n2 = this.oneReverseMul * this.oneComparator.compare(entry.slot, entry2.slot);
            if (n2 != 0) {
                return n2 > 0;
            }
            return entry.doc > entry2.doc;
        }
    }

    public static class Entry
    extends ScoreDoc {
        public int slot;

        public Entry(int n2, int n3, float f2) {
            super(n3, f2);
            this.slot = n2;
        }

        @Override
        public String toString() {
            return "slot:" + this.slot + " " + super.toString();
        }
    }
}

