/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.portmobile.util.Objects;

public final class Explanation {
    private final boolean match;
    private final float value;
    private final String description;
    private final List<Explanation> details;

    public static Explanation match(float f2, String string, Collection<Explanation> collection) {
        return new Explanation(true, f2, string, collection);
    }

    public static Explanation match(float f2, String string, Explanation ... explanationArray) {
        return new Explanation(true, f2, string, Arrays.asList(explanationArray));
    }

    private Explanation(boolean bl, float f2, String string, Collection<Explanation> collection) {
        this.match = bl;
        this.value = f2;
        this.description = Objects.requireNonNull(string);
        this.details = Collections.unmodifiableList(new ArrayList<Explanation>(collection));
        Iterator<Explanation> iterator = collection.iterator();
        while (iterator.hasNext()) {
            Objects.requireNonNull(iterator.next());
        }
    }

    public final float getValue() {
        return this.value;
    }

    public final String getDescription() {
        return this.description;
    }

    private String getSummary() {
        return this.getValue() + " = " + this.getDescription();
    }

    public final Explanation[] getDetails() {
        return this.details.toArray(new Explanation[0]);
    }

    public final String toString() {
        return this.toString(0);
    }

    private String toString(int n2) {
        StringBuilder stringBuilder = new StringBuilder();
        for (int i2 = 0; i2 < n2; ++i2) {
            stringBuilder.append("  ");
        }
        stringBuilder.append(this.getSummary());
        stringBuilder.append("\n");
        Explanation[] explanationArray = this.getDetails();
        for (int i3 = 0; i3 < explanationArray.length; ++i3) {
            stringBuilder.append(explanationArray[i3].toString(n2 + 1));
        }
        return stringBuilder.toString();
    }
}

