/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;

public abstract class DocIdSetIterator {
    public static final int NO_MORE_DOCS = Integer.MAX_VALUE;

    public static final DocIdSetIterator empty() {
        return new DocIdSetIterator(){
            boolean exhausted = false;

            @Override
            public final int advance(int n2) {
                assert (!this.exhausted);
                assert (n2 >= 0);
                this.exhausted = true;
                return Integer.MAX_VALUE;
            }

            @Override
            public final int docID() {
                if (this.exhausted) {
                    return Integer.MAX_VALUE;
                }
                return -1;
            }

            @Override
            public final int nextDoc() {
                assert (!this.exhausted);
                this.exhausted = true;
                return Integer.MAX_VALUE;
            }

            @Override
            public final long cost() {
                return 0L;
            }
        };
    }

    public static final DocIdSetIterator all(final int n2) {
        return new DocIdSetIterator(){
            int doc = -1;

            @Override
            public final int docID() {
                return this.doc;
            }

            @Override
            public final int nextDoc() throws IOException {
                return this.advance(this.doc + 1);
            }

            @Override
            public final int advance(int n22) throws IOException {
                this.doc = n22;
                if (this.doc >= n2) {
                    this.doc = Integer.MAX_VALUE;
                }
                return this.doc;
            }

            @Override
            public final long cost() {
                return n2;
            }
        };
    }

    public abstract int docID();

    public abstract int nextDoc() throws IOException;

    public abstract int advance(int var1) throws IOException;

    protected final int slowAdvance(int n2) throws IOException {
        int n3;
        assert (this.docID() < n2);
        while ((n3 = this.nextDoc()) < n2) {
        }
        return n3;
    }

    public abstract long cost();
}

