/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.List;
import org.apache.lucene.search.DisiWrapper;
import org.apache.lucene.search.DisjunctionScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

final class DisjunctionSumScorer
extends DisjunctionScorer {
    private final float[] coord;

    DisjunctionSumScorer(Weight weight, List<Scorer> list, float[] fArray, boolean bl) {
        super(weight, list, bl);
        this.coord = fArray;
    }

    @Override
    protected final float score(DisiWrapper<Scorer> disiWrapper) throws IOException {
        double d2 = 0.0;
        int n2 = 0;
        while (disiWrapper != null) {
            d2 += (double)((Scorer)disiWrapper.iterator).score();
            ++n2;
            disiWrapper = disiWrapper.next;
        }
        return (float)d2 * this.coord[n2];
    }
}

