/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.portmobile.util.Objects;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.g;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.ToStringUtils;

public class ConstantScoreQuery
extends Query {
    protected final Query query;

    public ConstantScoreQuery(Query query) {
        this.query = Objects.requireNonNull(query, "Query must not be null");
    }

    @Override
    public Query rewrite(IndexReader object) throws IOException {
        if ((object = this.query.rewrite((IndexReader)object)).getClass() == this.getClass()) {
            if (this.getBoost() != ((Query)object).getBoost()) {
                object = ((Query)object).clone();
                ((Query)object).setBoost(this.getBoost());
            }
            return object;
        }
        if (object != this.query) {
            object = new ConstantScoreQuery((Query)object);
            ((Query)object).setBoost(this.getBoost());
            return object;
        }
        return this;
    }

    @Override
    public Weight createWeight(IndexSearcher object, boolean bl) throws IOException {
        object = ((IndexSearcher)object).createWeight(this.query, false);
        if (bl) {
            return new ConstantScoreWeight(this, (Weight)object){
                final /* synthetic */ Weight val$innerWeight;
                {
                    this.val$innerWeight = weight;
                    super(query);
                }

                @Override
                public BulkScorer bulkScorer(LeafReaderContext object) throws IOException {
                    if ((object = this.val$innerWeight.bulkScorer((LeafReaderContext)object)) == null) {
                        return null;
                    }
                    return new ConstantBulkScorer((BulkScorer)object, this, this.score());
                }

                @Override
                public Scorer scorer(LeafReaderContext object) throws IOException {
                    if ((object = this.val$innerWeight.scorer((LeafReaderContext)object)) == null) {
                        return null;
                    }
                    final float f2 = this.score();
                    return new FilterScorer((Scorer)object, (Scorer)object){
                        final /* synthetic */ Scorer val$innerScorer;
                        {
                            this.val$innerScorer = scorer2;
                            super(scorer);
                        }

                        @Override
                        public float score() throws IOException {
                            return f2;
                        }

                        @Override
                        public int freq() throws IOException {
                            return 1;
                        }
                    };
                }
            };
        }
        return object;
    }

    @Override
    public String toString(String string) {
        return "ConstantScore(" + this.query.toString(string) + ')' + ToStringUtils.boost(this.getBoost());
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!super.equals(object)) {
            return false;
        }
        if (object instanceof ConstantScoreQuery) {
            object = (ConstantScoreQuery)object;
            return this.query.equals(((ConstantScoreQuery)object).query);
        }
        return false;
    }

    @Override
    public int hashCode() {
        return 31 * super.hashCode() + this.query.hashCode();
    }

    protected class ConstantBulkScorer
    extends BulkScorer {
        final BulkScorer bulkScorer;
        final Weight weight;
        final float theScore;

        public ConstantBulkScorer(BulkScorer bulkScorer, Weight weight, float f2) {
            this.bulkScorer = bulkScorer;
            this.weight = weight;
            this.theScore = f2;
        }

        @Override
        public int score(g g2, Bits bits, int n2, int n3) throws IOException {
            return this.bulkScorer.score(this.wrapCollector(g2), bits, n2, n3);
        }

        private g wrapCollector(g g2) {
            return new FilterLeafCollector(g2){

                @Override
                public void setScorer(Scorer scorer) throws IOException {
                    this.in.setScorer(new FilterScorer(scorer){

                        @Override
                        public float score() throws IOException {
                            return ConstantBulkScorer.this.theScore;
                        }

                        @Override
                        public int freq() throws IOException {
                            return 1;
                        }
                    });
                }
            };
        }

        @Override
        public long cost() {
            return this.bulkScorer.cost();
        }
    }
}

