/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.FilterCollector;
import org.apache.lucene.search.FilterLeafCollector;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.c;
import org.apache.lucene.search.g;
import org.apache.lucene.util.ArrayUtil;

public abstract class CachingCollector
extends FilterCollector {
    private boolean cached = true;

    public static CachingCollector create(c c2, boolean bl, double d2) {
        int n2 = 4;
        if (bl) {
            n2 += 4;
        }
        int n3 = (int)(d2 * 1024.0 * 1024.0 / (double)n2);
        return CachingCollector.create(c2, bl, n3);
    }

    public static CachingCollector create(c c2, boolean bl, int n2) {
        if (bl) {
            return new ScoreCachingCollector(c2, n2);
        }
        return new NoScoreCachingCollector(c2, n2);
    }

    private CachingCollector(c c2) {
        super(c2);
    }

    public final boolean isCached() {
        return this.cached;
    }

    public abstract void replay(c var1) throws IOException;

    private class ScoreCachingLeafCollector
    extends NoScoreCachingLeafCollector {
        Scorer scorer;
        float[] scores;

        ScoreCachingLeafCollector(g g2, int n2) {
            super(g2, n2);
            this.scores = new float[this.docs.length];
        }

        @Override
        public void setScorer(Scorer scorer) throws IOException {
            this.scorer = scorer;
            super.setScorer(scorer);
        }

        @Override
        protected void grow(int n2) {
            super.grow(n2);
            this.scores = Arrays.copyOf(this.scores, n2);
        }

        @Override
        protected void invalidate() {
            super.invalidate();
            this.scores = null;
        }

        @Override
        protected void buffer(int n2) throws IOException {
            super.buffer(n2);
            this.scores[this.docCount] = this.scorer.score();
        }

        float[] cachedScores() {
            if (this.docs == null) {
                return null;
            }
            return Arrays.copyOf(this.scores, this.docCount);
        }
    }

    private class NoScoreCachingLeafCollector
    extends FilterLeafCollector {
        final int maxDocsToCache;
        int[] docs;
        int docCount;

        NoScoreCachingLeafCollector(g g2, int n2) {
            super(g2);
            this.maxDocsToCache = n2;
            this.docs = new int[Math.min(n2, 128)];
            this.docCount = 0;
        }

        protected void grow(int n2) {
            this.docs = Arrays.copyOf(this.docs, n2);
        }

        protected void invalidate() {
            this.docs = null;
            this.docCount = -1;
            CachingCollector.this.cached = false;
        }

        protected void buffer(int n2) throws IOException {
            this.docs[this.docCount] = n2;
        }

        @Override
        public void collect(int n2) throws IOException {
            if (this.docs != null) {
                if (this.docCount >= this.docs.length) {
                    if (this.docCount >= this.maxDocsToCache) {
                        this.invalidate();
                    } else {
                        int n3 = Math.min(ArrayUtil.oversize(this.docCount + 1, 4), this.maxDocsToCache);
                        this.grow(n3);
                    }
                }
                if (this.docs != null) {
                    this.buffer(n2);
                    ++this.docCount;
                }
            }
            super.collect(n2);
        }

        boolean hasCache() {
            return this.docs != null;
        }

        int[] cachedDocs() {
            if (this.docs == null) {
                return null;
            }
            return Arrays.copyOf(this.docs, this.docCount);
        }
    }

    private static class ScoreCachingCollector
    extends NoScoreCachingCollector {
        List<float[]> scores = new ArrayList<float[]>();

        ScoreCachingCollector(c c2, int n2) {
            super(c2, n2);
        }

        @Override
        protected NoScoreCachingLeafCollector wrap(g g2, int n2) {
            return new ScoreCachingLeafCollector(g2, n2);
        }

        @Override
        protected void postCollect(NoScoreCachingLeafCollector noScoreCachingLeafCollector) {
            noScoreCachingLeafCollector = (ScoreCachingLeafCollector)noScoreCachingLeafCollector;
            super.postCollect(noScoreCachingLeafCollector);
            this.scores.add(((ScoreCachingLeafCollector)noScoreCachingLeafCollector).cachedScores());
        }

        @Override
        protected void collect(g g2, int n2) throws IOException {
            int[] nArray = (int[])this.docs.get(n2);
            float[] fArray = this.scores.get(n2);
            assert (nArray.length == fArray.length);
            CachedScorer cachedScorer = new CachedScorer();
            g2.setScorer(cachedScorer);
            for (int i2 = 0; i2 < nArray.length; ++i2) {
                cachedScorer.doc = nArray[i2];
                cachedScorer.score = fArray[i2];
                g2.collect(cachedScorer.doc);
            }
        }
    }

    private static class NoScoreCachingCollector
    extends CachingCollector {
        List<LeafReaderContext> contexts;
        List<int[]> docs;
        int maxDocsToCache;
        NoScoreCachingLeafCollector lastCollector;

        NoScoreCachingCollector(c c2, int n2) {
            super(c2);
            this.maxDocsToCache = n2;
            this.contexts = new ArrayList<LeafReaderContext>();
            this.docs = new ArrayList<int[]>();
        }

        protected NoScoreCachingLeafCollector wrap(g g2, int n2) {
            return new NoScoreCachingLeafCollector(g2, n2);
        }

        @Override
        public g getLeafCollector(LeafReaderContext leafReaderContext) throws IOException {
            this.postCollection();
            g g2 = this.in.getLeafCollector(leafReaderContext);
            if (this.contexts != null) {
                this.contexts.add(leafReaderContext);
            }
            if (this.maxDocsToCache >= 0) {
                this.lastCollector = this.wrap(g2, this.maxDocsToCache);
                return this.lastCollector;
            }
            return g2;
        }

        protected void invalidate() {
            this.maxDocsToCache = -1;
            this.contexts = null;
            this.docs = null;
        }

        protected void postCollect(NoScoreCachingLeafCollector object) {
            object = ((NoScoreCachingLeafCollector)object).cachedDocs();
            this.maxDocsToCache -= ((Object)object).length;
            this.docs.add((int[])object);
        }

        private void postCollection() {
            if (this.lastCollector != null) {
                if (!this.lastCollector.hasCache()) {
                    this.invalidate();
                } else {
                    this.postCollect(this.lastCollector);
                }
                this.lastCollector = null;
            }
        }

        protected void collect(g g2, int n2) throws IOException {
            for (int n3 : this.docs.get(n2)) {
                g2.collect(n3);
            }
        }

        @Override
        public void replay(c c2) throws IOException {
            this.postCollection();
            if (!this.isCached()) {
                throw new IllegalStateException("cannot replay: cache was cleared because too much RAM was required");
            }
            assert (this.docs.size() == this.contexts.size());
            for (int i2 = 0; i2 < this.contexts.size(); ++i2) {
                Object object = this.contexts.get(i2);
                object = c2.getLeafCollector((LeafReaderContext)object);
                this.collect((g)object, i2);
            }
        }
    }

    private static final class CachedScorer
    extends Scorer {
        int doc;
        float score;

        private CachedScorer() {
            super(null);
        }

        @Override
        public final float score() {
            return this.score;
        }

        @Override
        public final int advance(int n2) {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int docID() {
            return this.doc;
        }

        @Override
        public final int freq() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final int nextDoc() {
            throw new UnsupportedOperationException();
        }

        @Override
        public final long cost() {
            return 1L;
        }
    }
}

