/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.BooleanScorer;
import org.apache.lucene.search.BooleanTopLevelScorers;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.ConjunctionScorer;
import org.apache.lucene.search.DisjunctionSumScorer;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.MinShouldMatchSumScorer;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.ReqExclScorer;
import org.apache.lucene.search.ReqOptSumScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;
import org.apache.lucene.search.similarities.a;

final class BooleanWeight
extends Weight {
    final a similarity;
    final BooleanQuery query;
    final ArrayList<Weight> weights;
    final int maxCoord;
    final boolean disableCoord;
    final boolean needsScores;
    final float[] coords;

    BooleanWeight(BooleanQuery object, IndexSearcher indexSearcher, boolean bl, boolean bl2) throws IOException {
        super((Query)object);
        this.query = object;
        this.needsScores = bl;
        this.similarity = indexSearcher.getSimilarity(bl);
        this.weights = new ArrayList();
        int n2 = 0;
        Iterator<BooleanClause> iterator = ((BooleanQuery)object).iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            Weight weight = indexSearcher.createWeight(((BooleanClause)object).getQuery(), bl && ((BooleanClause)object).isScoring());
            this.weights.add(weight);
            if (!((BooleanClause)object).isScoring()) continue;
            ++n2;
        }
        this.maxCoord = n2;
        this.coords = new float[n2 + 1];
        Arrays.fill(this.coords, 1.0f);
        this.coords[0] = 0.0f;
        if (n2 > 0 && bl && !bl2) {
            boolean bl3 = false;
            for (int i2 = 1; i2 < this.coords.length; ++i2) {
                this.coords[i2] = this.coord(i2, n2);
                bl3 |= this.coords[i2] != 1.0f;
            }
            this.disableCoord = !bl3;
            return;
        }
        this.disableCoord = true;
    }

    @Override
    public final float getValueForNormalization() throws IOException {
        float f2 = 0.0f;
        int n2 = 0;
        for (BooleanClause booleanClause : this.query) {
            float f3 = this.weights.get(n2).getValueForNormalization();
            if (booleanClause.isScoring()) {
                f2 += f3;
            }
            ++n2;
        }
        return f2 * (this.query.getBoost() * this.query.getBoost());
    }

    public final float coord(int n2, int n3) {
        if (n2 == 0) {
            return 0.0f;
        }
        if (n3 == 1) {
            return 1.0f;
        }
        return this.similarity.coord(n2, n3);
    }

    @Override
    public final void normalize(float f2, float f3) {
        f3 *= this.query.getBoost();
        Iterator<Weight> iterator = this.weights.iterator();
        while (iterator.hasNext()) {
            iterator.next().normalize(f2, f3);
        }
    }

    final BooleanScorer booleanScorer(LeafReaderContext leafReaderContext) throws IOException {
        ArrayList<BulkScorer> arrayList = new ArrayList<BulkScorer>();
        Iterator<BooleanClause> iterator = this.query.iterator();
        for (Weight weight : this.weights) {
            BooleanClause booleanClause = iterator.next();
            BulkScorer object = weight.bulkScorer(leafReaderContext);
            if (object == null) {
                if (!booleanClause.isRequired()) continue;
                return null;
            }
            if (booleanClause.isRequired()) {
                return null;
            }
            if (booleanClause.isProhibited()) {
                return null;
            }
            arrayList.add(object);
        }
        if (arrayList.size() == 0) {
            return null;
        }
        if (this.query.getMinimumNumberShouldMatch() > arrayList.size()) {
            return null;
        }
        return new BooleanScorer(this, this.disableCoord, this.maxCoord, arrayList, Math.max(1, this.query.getMinimumNumberShouldMatch()), this.needsScores);
    }

    @Override
    public final BulkScorer bulkScorer(LeafReaderContext leafReaderContext) throws IOException {
        BooleanScorer booleanScorer = this.booleanScorer(leafReaderContext);
        if (booleanScorer != null) {
            long l2 = this.query.getMinimumNumberShouldMatch() <= 1 ? -1L : (long)(leafReaderContext.reader().maxDoc() / 3);
            if (booleanScorer.cost() > l2) {
                return booleanScorer;
            }
        }
        return super.bulkScorer(leafReaderContext);
    }

    @Override
    public final Scorer scorer(LeafReaderContext leafReaderContext) throws IOException {
        int n2 = this.query.getMinimumNumberShouldMatch();
        ArrayList<Scorer> arrayList = new ArrayList<Scorer>();
        ArrayList<Scorer> arrayList2 = new ArrayList<Scorer>();
        ArrayList<Scorer> arrayList3 = new ArrayList<Scorer>();
        ArrayList<Scorer> arrayList4 = new ArrayList<Scorer>();
        Iterator<BooleanClause> iterator = this.query.iterator();
        for (Weight object2 : this.weights) {
            BooleanClause f2 = iterator.next();
            Scorer f3 = object2.scorer(leafReaderContext);
            if (f3 == null) {
                if (!f2.isRequired()) continue;
                return null;
            }
            if (f2.isRequired()) {
                arrayList.add(f3);
                if (!f2.isScoring()) continue;
                arrayList2.add(f3);
                continue;
            }
            if (f2.isProhibited()) {
                arrayList3.add(f3);
                continue;
            }
            arrayList4.add(f3);
        }
        if (arrayList4.size() == n2) {
            arrayList.addAll(arrayList4);
            arrayList2.addAll(arrayList4);
            arrayList4.clear();
            n2 = 0;
        }
        if (arrayList.isEmpty() && arrayList4.isEmpty()) {
            return null;
        }
        if (arrayList4.size() < n2) {
            return null;
        }
        if (!this.needsScores && n2 == 0 && arrayList.size() > 0) {
            arrayList4.clear();
        }
        if (arrayList4.isEmpty()) {
            return this.excl(this.req(arrayList, arrayList2, this.disableCoord), arrayList3);
        }
        if (arrayList.isEmpty()) {
            return this.excl(this.opt(arrayList4, n2, this.disableCoord), arrayList3);
        }
        Scorer scorer = this.excl(this.req(arrayList, arrayList2, true), arrayList3);
        Scorer scorer2 = this.opt(arrayList4, n2, true);
        if (this.disableCoord) {
            if (n2 > 0) {
                return new ConjunctionScorer(this, Arrays.asList(scorer, scorer2), Arrays.asList(scorer, scorer2), 1.0f);
            }
            return new ReqOptSumScorer(scorer, scorer2);
        }
        if (arrayList4.size() == 1) {
            if (n2 > 0) {
                return new ConjunctionScorer(this, Arrays.asList(scorer, scorer2), Arrays.asList(scorer, scorer2), this.coord(arrayList2.size() + 1, this.maxCoord));
            }
            float f2 = this.coord(arrayList2.size(), this.maxCoord);
            float f3 = this.coord(arrayList2.size() + 1, this.maxCoord);
            return new BooleanTopLevelScorers.ReqSingleOptScorer(scorer, scorer2, f2, f3);
        }
        if (n2 > 0) {
            return new BooleanTopLevelScorers.CoordinatingConjunctionScorer(this, this.coords, scorer, arrayList2.size(), scorer2);
        }
        return new BooleanTopLevelScorers.ReqMultiOptScorer(scorer, scorer2, arrayList2.size(), this.coords);
    }

    private Scorer req(List<Scorer> object, List<Scorer> list, boolean bl) {
        if (object.size() == 1) {
            object = object.get(0);
            if (!this.needsScores) {
                return object;
            }
            if (list.isEmpty()) {
                return new FilterScorer((Scorer)object){

                    @Override
                    public float score() throws IOException {
                        return 0.0f;
                    }

                    @Override
                    public int freq() throws IOException {
                        return 0;
                    }
                };
            }
            float f2 = 1.0f;
            if (!bl) {
                f2 = this.coord(1, this.maxCoord);
            }
            if (f2 == 1.0f) {
                return object;
            }
            return new BooleanTopLevelScorers.BoostedScorer((Scorer)object, f2);
        }
        return new ConjunctionScorer(this, (List<? extends DocIdSetIterator>)object, list, bl ? 1.0f : this.coord(list.size(), this.maxCoord));
    }

    private Scorer excl(Scorer scorer, List<Scorer> list) throws IOException {
        if (list.isEmpty()) {
            return scorer;
        }
        if (list.size() == 1) {
            return new ReqExclScorer(scorer, list.get(0));
        }
        float[] fArray = new float[list.size() + 1];
        Arrays.fill(fArray, 1.0f);
        return new ReqExclScorer(scorer, new DisjunctionSumScorer(this, list, fArray, false));
    }

    private Scorer opt(List<Scorer> list, int n2, boolean bl) throws IOException {
        float[] fArray;
        if (list.size() == 1) {
            Scorer scorer = list.get(0);
            if (!bl && this.maxCoord > 1) {
                return new BooleanTopLevelScorers.BoostedScorer(scorer, this.coord(1, this.maxCoord));
            }
            return scorer;
        }
        if (bl) {
            fArray = new float[list.size() + 1];
            Arrays.fill(fArray, 1.0f);
        } else {
            fArray = this.coords;
        }
        if (n2 > 1) {
            return new MinShouldMatchSumScorer(this, list, n2, fArray);
        }
        return new DisjunctionSumScorer(this, list, fArray, this.needsScores);
    }
}

