/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import org.apache.lucene.search.ConjunctionScorer;
import org.apache.lucene.search.FilterScorer;
import org.apache.lucene.search.ReqOptSumScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

final class BooleanTopLevelScorers {

    static class ReqMultiOptScorer
    extends ReqOptSumScorer {
        private final int requiredCount;
        private final float[] coords;

        public ReqMultiOptScorer(Scorer scorer, Scorer scorer2, int n2, float[] fArray) {
            super(scorer, scorer2);
            this.requiredCount = n2;
            this.coords = fArray;
        }

        @Override
        public float score() throws IOException {
            int n2 = this.reqScorer.docID();
            float f2 = this.reqScorer.score();
            if (this.optScorer == null) {
                return f2 * this.coords[this.requiredCount];
            }
            int n3 = this.optScorer.docID();
            if (n3 < n2 && (n3 = this.optScorer.advance(n2)) == Integer.MAX_VALUE) {
                this.optScorer = null;
                return f2 * this.coords[this.requiredCount];
            }
            if (n3 == n2) {
                return (f2 + this.optScorer.score()) * this.coords[this.requiredCount + this.optScorer.freq()];
            }
            return f2 * this.coords[this.requiredCount];
        }
    }

    static class ReqSingleOptScorer
    extends ReqOptSumScorer {
        private final float coordReq;
        private final float coordBoth;

        public ReqSingleOptScorer(Scorer scorer, Scorer scorer2, float f2, float f3) {
            super(scorer, scorer2);
            this.coordReq = f2;
            this.coordBoth = f3;
        }

        @Override
        public float score() throws IOException {
            int n2 = this.reqScorer.docID();
            float f2 = this.reqScorer.score();
            if (this.optScorer == null) {
                return f2 * this.coordReq;
            }
            int n3 = this.optScorer.docID();
            if (n3 < n2 && (n3 = this.optScorer.advance(n2)) == Integer.MAX_VALUE) {
                this.optScorer = null;
                return f2 * this.coordReq;
            }
            if (n3 == n2) {
                return (f2 + this.optScorer.score()) * this.coordBoth;
            }
            return f2 * this.coordReq;
        }
    }

    static class CoordinatingConjunctionScorer
    extends ConjunctionScorer {
        private final float[] coords;
        private final int reqCount;
        private final Scorer req;
        private final Scorer opt;

        CoordinatingConjunctionScorer(Weight weight, float[] fArray, Scorer scorer, int n2, Scorer scorer2) {
            super(weight, Arrays.asList(scorer, scorer2), Arrays.asList(scorer, scorer2));
            this.coords = fArray;
            this.req = scorer;
            this.reqCount = n2;
            this.opt = scorer2;
        }

        @Override
        public float score() throws IOException {
            return (this.req.score() + this.opt.score()) * this.coords[this.reqCount + this.opt.freq()];
        }
    }

    static class BoostedScorer
    extends FilterScorer {
        final float boost;

        BoostedScorer(Scorer scorer, float f2) {
            super(scorer);
            this.boost = f2;
        }

        @Override
        public float score() throws IOException {
            return this.in.score() * this.boost;
        }
    }
}

