/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.portmobile.annotations.Weak;
import org.apache.lucene.search.BooleanWeight;
import org.apache.lucene.search.BulkScorer;
import org.apache.lucene.search.FakeScorer;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.g;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.PriorityQueue;

final class BooleanScorer
extends BulkScorer {
    final Bucket[] buckets = new Bucket[2048];
    final long[] matching = new long[32];
    final float[] coordFactors;
    final BulkScorerAndDoc[] leads;
    final a head;
    final b tail;
    final FakeScorer fakeScorer = new FakeScorer();
    final int minShouldMatch;
    final long cost;
    final OrCollector orCollector = new OrCollector();

    private static BulkScorer disableScoring(final BulkScorer bulkScorer) {
        return new BulkScorer(){

            @Override
            public final int score(final g g2, Bits bits, int n2, int n3) throws IOException {
                g2 = new g(){
                    FakeScorer fake = new FakeScorer();

                    @Override
                    public void setScorer(Scorer scorer) throws IOException {
                        g2.setScorer(this.fake);
                    }

                    @Override
                    public void collect(int n2) throws IOException {
                        this.fake.doc = n2;
                        g2.collect(n2);
                    }
                };
                return bulkScorer.score(g2, bits, n2, n3);
            }

            @Override
            public final long cost() {
                return bulkScorer.cost();
            }
        };
    }

    private static long cost(Collection<BulkScorer> object, int n2) {
        PriorityQueue<BulkScorer> priorityQueue = new PriorityQueue<BulkScorer>(object.size() - n2 + 1){

            @Override
            protected final /* synthetic */ boolean lessThan(Object object, Object object2) {
                object2 = (BulkScorer)object2;
                return ((BulkScorer)object).cost() > ((BulkScorer)object2).cost();
            }
        };
        Iterator<BulkScorer> iterator = object.iterator();
        while (iterator.hasNext()) {
            BulkScorer bulkScorer = iterator.next();
            priorityQueue.insertWithOverflow(bulkScorer);
        }
        long l2 = 0L;
        object = (BulkScorer)priorityQueue.pop();
        while (object != null) {
            l2 += ((BulkScorer)object).cost();
            object = (BulkScorer)priorityQueue.pop();
        }
        return l2;
    }

    /*
     * WARNING - void declaration
     */
    BooleanScorer(BooleanWeight booleanWeight, boolean bl, int n2, Collection<BulkScorer> collection, int n3, boolean bl2) {
        if (n3 <= 0 || n3 > collection.size()) {
            throw new IllegalArgumentException("minShouldMatch should be within 1..num_scorers. Got " + n3);
        }
        for (int i2 = 0; i2 < this.buckets.length; ++i2) {
            this.buckets[i2] = new Bucket();
        }
        this.leads = new BulkScorerAndDoc[collection.size()];
        this.head = new a(collection.size() - n3 + 1);
        this.tail = new b(n3 - 1);
        this.minShouldMatch = n3;
        for (BulkScorer bulkScorer : collection) {
            void var8_13;
            BulkScorerAndDoc object;
            if (!bl2) {
                BulkScorer bulkScorer2 = BooleanScorer.disableScoring(bulkScorer);
            }
            if ((object = this.tail.insertWithOverflow(new BulkScorerAndDoc((BulkScorer)var8_13))) == null) continue;
            this.head.add(object);
        }
        this.cost = BooleanScorer.cost(collection, n3);
        this.coordFactors = new float[collection.size() + 1];
        for (int i3 = 0; i3 < this.coordFactors.length; ++i3) {
            this.coordFactors[i3] = bl ? 1.0f : booleanWeight.coord(i3, n2);
        }
    }

    @Override
    public final long cost() {
        return this.cost;
    }

    private void scoreDocument(g g2, int n2, int n3) throws IOException {
        FakeScorer fakeScorer = this.fakeScorer;
        Bucket bucket = this.buckets[n3];
        if (bucket.freq >= this.minShouldMatch) {
            fakeScorer.freq = bucket.freq;
            fakeScorer.score = (float)bucket.score * this.coordFactors[bucket.freq];
            fakeScorer.doc = n2 |= n3;
            g2.collect(n2);
        }
        bucket.freq = 0;
        bucket.score = 0.0;
    }

    private void scoreMatches(g g2, int n2) throws IOException {
        long[] lArray = this.matching;
        for (int i2 = 0; i2 < lArray.length; ++i2) {
            int n3;
            for (long i3 = lArray[i2]; i3 != 0L; i3 ^= 1L << n3) {
                n3 = Long.numberOfTrailingZeros(i3);
                int n4 = i2 << 6 | n3;
                this.scoreDocument(g2, n2, n4);
            }
        }
    }

    private void scoreWindow(g g2, Bits bits, int n2, int n3, int n4, BulkScorerAndDoc[] bulkScorerAndDocArray, int n5) throws IOException {
        for (int i2 = 0; i2 < n5; ++i2) {
            BulkScorerAndDoc bulkScorerAndDoc = bulkScorerAndDocArray[i2];
            assert (bulkScorerAndDoc.next < n4);
            bulkScorerAndDoc.score(bits, n3, n4);
        }
        this.scoreMatches(g2, n2);
        Arrays.fill(this.matching, 0L);
    }

    private BulkScorerAndDoc advance(int n2) throws IOException {
        assert (this.tail.size() == this.minShouldMatch - 1);
        a a2 = this.head;
        b b2 = this.tail;
        BulkScorerAndDoc bulkScorerAndDoc = (BulkScorerAndDoc)a2.top();
        BulkScorerAndDoc bulkScorerAndDoc2 = (BulkScorerAndDoc)b2.top();
        while (bulkScorerAndDoc.next < n2) {
            if (bulkScorerAndDoc2 == null || bulkScorerAndDoc.cost <= bulkScorerAndDoc2.cost) {
                bulkScorerAndDoc.advance(n2);
                bulkScorerAndDoc = (BulkScorerAndDoc)a2.updateTop();
                continue;
            }
            BulkScorerAndDoc bulkScorerAndDoc3 = bulkScorerAndDoc;
            bulkScorerAndDoc2.advance(n2);
            bulkScorerAndDoc = a2.updateTop(bulkScorerAndDoc2);
            bulkScorerAndDoc2 = b2.updateTop(bulkScorerAndDoc3);
        }
        return bulkScorerAndDoc;
    }

    private void scoreWindow(g object, Bits bits, int n2, int n3, int n4) throws IOException {
        this.leads[0] = (BulkScorerAndDoc)this.head.pop();
        int n5 = 1;
        while (this.head.size() > 0 && ((BulkScorerAndDoc)this.head.top()).next < n4) {
            this.leads[n5++] = (BulkScorerAndDoc)this.head.pop();
        }
        while (n5 < this.minShouldMatch && n5 + this.tail.size() >= this.minShouldMatch) {
            BulkScorerAndDoc bulkScorerAndDoc = (BulkScorerAndDoc)this.tail.pop();
            bulkScorerAndDoc.advance(n3);
            if (bulkScorerAndDoc.next < n4) {
                this.leads[n5++] = bulkScorerAndDoc;
                continue;
            }
            this.head.add(bulkScorerAndDoc);
        }
        if (n5 >= this.minShouldMatch) {
            for (int i2 = 0; i2 < this.tail.size(); ++i2) {
                this.leads[n5++] = this.tail.a(i2);
            }
            this.tail.clear();
            this.scoreWindow((g)object, bits, n2, n3, n4, this.leads, n5);
        }
        for (int i3 = 0; i3 < n5; ++i3) {
            object = this.head.insertWithOverflow(this.leads[i3]);
            if (object == null) continue;
            this.tail.add(object);
        }
    }

    @Override
    public final int score(g g2, Bits bits, int n2, int n3) throws IOException {
        this.fakeScorer.doc = -1;
        g2.setScorer(this.fakeScorer);
        BulkScorerAndDoc bulkScorerAndDoc = this.advance(n2);
        while (bulkScorerAndDoc.next < n3) {
            int n4 = bulkScorerAndDoc.next & 0xFFFFF800;
            int n5 = Math.max(n2, n4);
            int n6 = Math.min(n3, n4 + 2048);
            this.scoreWindow(g2, bits, n4, n5, n6);
            bulkScorerAndDoc = (BulkScorerAndDoc)this.head.top();
        }
        return bulkScorerAndDoc.next;
    }

    final class OrCollector
    implements g {
        @Weak
        Scorer scorer;

        OrCollector() {
        }

        @Override
        public final void setScorer(Scorer scorer) {
            this.scorer = scorer;
        }

        @Override
        public final void collect(int n2) throws IOException {
            int n3;
            int n4 = n3 = (n2 &= 0x7FF) >>> 6;
            BooleanScorer.this.matching[n4] = BooleanScorer.this.matching[n4] | 1L << n2;
            Bucket bucket = BooleanScorer.this.buckets[n2];
            ++bucket.freq;
            bucket.score += (double)this.scorer.score();
        }
    }

    static final class b
    extends PriorityQueue<BulkScorerAndDoc> {
        public b(int n2) {
            super(n2);
        }

        public final BulkScorerAndDoc a(int n2) {
            if (n2 < 0 || n2 >= this.size()) {
                throw new IndexOutOfBoundsException();
            }
            return (BulkScorerAndDoc)this.getHeapArray()[n2 + 1];
        }
    }

    static final class a
    extends PriorityQueue<BulkScorerAndDoc> {
        public a(int n2) {
            super(n2);
        }
    }

    private class BulkScorerAndDoc {
        @Weak
        final BulkScorer scorer;
        final long cost;
        int next;

        BulkScorerAndDoc(BulkScorer bulkScorer) {
            this.scorer = bulkScorer;
            this.cost = bulkScorer.cost();
            this.next = -1;
        }

        void advance(int n2) throws IOException {
            this.score(null, n2, n2);
        }

        void score(Bits bits, int n2, int n3) throws IOException {
            this.next = this.scorer.score(BooleanScorer.this.orCollector, bits, n2, n3);
        }
    }

    static class Bucket {
        double score;
        int freq;

        Bucket() {
        }
    }
}

