/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.analysis.tokenattributes.g;
import org.apache.lucene.index.ByteSliceReader;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.ParallelPostingsArray;
import org.apache.lucene.index.TermsHash;
import org.apache.lucene.index.j;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IntBlockPool;

abstract class TermsHashPerField
implements Comparable<TermsHashPerField> {
    final TermsHash termsHash;
    final TermsHashPerField nextPerField;
    protected final DocumentsWriterPerThread.DocState docState;
    protected final FieldInvertState fieldState;
    g termAtt;
    final IntBlockPool intPool;
    final ByteBlockPool bytePool;
    final ByteBlockPool termBytePool;
    final int streamCount;
    final int numPostingInt;
    protected final FieldInfo fieldInfo;
    final BytesRefHash bytesHash;
    ParallelPostingsArray postingsArray;
    private final Counter bytesUsed;
    int[] sortedTermIDs;
    private boolean doNextCall;
    int[] intUptos;
    int intUptoStart;

    public TermsHashPerField(int n2, FieldInvertState fieldInvertState, TermsHash termsHash, TermsHashPerField termsHashPerField, FieldInfo fieldInfo) {
        this.intPool = termsHash.intPool;
        this.bytePool = termsHash.bytePool;
        this.termBytePool = termsHash.termBytePool;
        this.docState = termsHash.docState;
        this.termsHash = termsHash;
        this.bytesUsed = termsHash.bytesUsed;
        this.fieldState = fieldInvertState;
        this.streamCount = n2;
        this.numPostingInt = 2 * n2;
        this.fieldInfo = fieldInfo;
        this.nextPerField = termsHashPerField;
        PostingsBytesStartArray postingsBytesStartArray = new PostingsBytesStartArray(this, this.bytesUsed);
        this.bytesHash = new BytesRefHash(this.termBytePool, 4, postingsBytesStartArray);
    }

    void reset() {
        this.bytesHash.clear(false);
        if (this.nextPerField != null) {
            this.nextPerField.reset();
        }
    }

    public void initReader(ByteSliceReader byteSliceReader, int n2, int n3) {
        assert (n3 < this.streamCount);
        int n4 = this.postingsArray.intStarts[n2];
        int[] nArray = this.intPool.buffers[n4 >> 13];
        byteSliceReader.init(this.bytePool, this.postingsArray.byteStarts[n2] + n3 * ByteBlockPool.FIRST_LEVEL_SIZE, nArray[(n4 &= 0x1FFF) + n3]);
    }

    public int[] sortPostings() {
        this.sortedTermIDs = this.bytesHash.sort(BytesRef.getUTF8SortedAsUnicodeComparator());
        return this.sortedTermIDs;
    }

    public void add(int n2) throws IOException {
        if ((n2 = this.bytesHash.addByPoolOffset(n2)) >= 0) {
            if (this.numPostingInt + this.intPool.intUpto > 8192) {
                this.intPool.nextBuffer();
            }
            if (32768 - this.bytePool.byteUpto < this.numPostingInt * ByteBlockPool.FIRST_LEVEL_SIZE) {
                this.bytePool.nextBuffer();
            }
            this.intUptos = this.intPool.buffer;
            this.intUptoStart = this.intPool.intUpto;
            this.intPool.intUpto += this.streamCount;
            this.postingsArray.intStarts[n2] = this.intUptoStart + this.intPool.intOffset;
            for (int i2 = 0; i2 < this.streamCount; ++i2) {
                int n3 = this.bytePool.newSlice(ByteBlockPool.FIRST_LEVEL_SIZE);
                this.intUptos[this.intUptoStart + i2] = n3 + this.bytePool.byteOffset;
            }
            this.postingsArray.byteStarts[n2] = this.intUptos[this.intUptoStart];
            this.newTerm(n2);
            return;
        }
        n2 = -n2 - 1;
        int n4 = this.postingsArray.intStarts[n2];
        this.intUptos = this.intPool.buffers[n4 >> 13];
        this.intUptoStart = n4 & 0x1FFF;
        this.addTerm(n2);
    }

    void add() throws IOException {
        int n2 = this.bytesHash.add(this.termAtt.getBytesRef());
        if (n2 >= 0) {
            this.bytesHash.byteStart(n2);
            if (this.numPostingInt + this.intPool.intUpto > 8192) {
                this.intPool.nextBuffer();
            }
            if (32768 - this.bytePool.byteUpto < this.numPostingInt * ByteBlockPool.FIRST_LEVEL_SIZE) {
                this.bytePool.nextBuffer();
            }
            this.intUptos = this.intPool.buffer;
            this.intUptoStart = this.intPool.intUpto;
            this.intPool.intUpto += this.streamCount;
            this.postingsArray.intStarts[n2] = this.intUptoStart + this.intPool.intOffset;
            for (int i2 = 0; i2 < this.streamCount; ++i2) {
                int n3 = this.bytePool.newSlice(ByteBlockPool.FIRST_LEVEL_SIZE);
                this.intUptos[this.intUptoStart + i2] = n3 + this.bytePool.byteOffset;
            }
            this.postingsArray.byteStarts[n2] = this.intUptos[this.intUptoStart];
            this.newTerm(n2);
        } else {
            n2 = -n2 - 1;
            int n4 = this.postingsArray.intStarts[n2];
            this.intUptos = this.intPool.buffers[n4 >> 13];
            this.intUptoStart = n4 & 0x1FFF;
            this.addTerm(n2);
        }
        if (this.doNextCall) {
            this.nextPerField.add(this.postingsArray.textStarts[n2]);
        }
    }

    void writeByte(int n2, byte by) {
        int n3 = this.intUptos[this.intUptoStart + n2];
        byte[] byArray = this.bytePool.buffers[n3 >> 15];
        assert (byArray != null);
        if (byArray[n3 &= Short.MAX_VALUE] != 0) {
            n3 = this.bytePool.allocSlice(byArray, n3);
            byArray = this.bytePool.buffer;
            this.intUptos[this.intUptoStart + n2] = n3 + this.bytePool.byteOffset;
        }
        byArray[n3] = by;
        int n4 = this.intUptoStart + n2;
        this.intUptos[n4] = this.intUptos[n4] + 1;
    }

    public void writeBytes(int n2, byte[] byArray, int n3, int n4) {
        n4 = n3 + n4;
        while (n3 < n4) {
            this.writeByte(n2, byArray[n3]);
            ++n3;
        }
    }

    void writeVInt(int n2, int n3) {
        assert (n2 < this.streamCount);
        while ((n3 & 0xFFFFFF80) != 0) {
            this.writeByte(n2, (byte)(n3 & 0x7F | 0x80));
            n3 >>>= 7;
        }
        this.writeByte(n2, (byte)n3);
    }

    @Override
    public int compareTo(TermsHashPerField termsHashPerField) {
        return this.fieldInfo.name.compareTo(termsHashPerField.fieldInfo.name);
    }

    void finish() throws IOException {
        if (this.nextPerField != null) {
            this.nextPerField.finish();
        }
    }

    boolean start(j j2, boolean bl) {
        this.termAtt = this.fieldState.termAttribute;
        if (this.nextPerField != null) {
            this.doNextCall = this.nextPerField.start(j2, bl);
        }
        return true;
    }

    abstract void newTerm(int var1) throws IOException;

    abstract void addTerm(int var1) throws IOException;

    abstract void newPostingsArray();

    abstract ParallelPostingsArray createPostingsArray(int var1);

    private static final class PostingsBytesStartArray
    extends BytesRefHash.a {
        private final TermsHashPerField perField;
        private final Counter bytesUsed;

        private PostingsBytesStartArray(TermsHashPerField termsHashPerField, Counter counter) {
            this.perField = termsHashPerField;
            this.bytesUsed = counter;
        }

        @Override
        public final int[] init() {
            if (this.perField.postingsArray == null) {
                this.perField.postingsArray = this.perField.createPostingsArray(2);
                this.perField.newPostingsArray();
                this.bytesUsed.addAndGet(this.perField.postingsArray.size * this.perField.postingsArray.bytesPerPosting());
            }
            return this.perField.postingsArray.textStarts;
        }

        @Override
        public final int[] grow() {
            ParallelPostingsArray parallelPostingsArray = this.perField.postingsArray;
            int n2 = this.perField.postingsArray.size;
            parallelPostingsArray = this.perField.postingsArray = parallelPostingsArray.grow();
            this.perField.newPostingsArray();
            this.bytesUsed.addAndGet(parallelPostingsArray.bytesPerPosting() * (parallelPostingsArray.size - n2));
            return parallelPostingsArray.textStarts;
        }

        @Override
        public final int[] clear() {
            if (this.perField.postingsArray != null) {
                this.bytesUsed.addAndGet(-(this.perField.postingsArray.size * this.perField.postingsArray.bytesPerPosting()));
                this.perField.postingsArray = null;
                this.perField.newPostingsArray();
            }
            return null;
        }

        @Override
        public final Counter bytesUsed() {
            return this.bytesUsed;
        }
    }
}

