/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.IntBlockPool;

abstract class TermsHash {
    final TermsHash nextTermsHash;
    final IntBlockPool intPool;
    final ByteBlockPool bytePool;
    ByteBlockPool termBytePool;
    final Counter bytesUsed;
    final DocumentsWriterPerThread.DocState docState;
    final boolean trackAllocations;

    TermsHash(DocumentsWriterPerThread documentsWriterPerThread, boolean bl, TermsHash termsHash) {
        this.docState = documentsWriterPerThread.docState;
        this.trackAllocations = bl;
        this.nextTermsHash = termsHash;
        this.bytesUsed = bl ? documentsWriterPerThread.bytesUsed : Counter.newCounter();
        this.intPool = new IntBlockPool(documentsWriterPerThread.intBlockAllocator);
        this.bytePool = new ByteBlockPool(documentsWriterPerThread.byteBlockAllocator);
        if (termsHash != null) {
            this.termBytePool = this.bytePool;
            termsHash.termBytePool = this.bytePool;
        }
    }

    public void abort() {
        try {
            this.reset();
            if (this.nextTermsHash != null) {
                this.nextTermsHash.abort();
                return;
            }
        }
        catch (Throwable throwable) {
            if (this.nextTermsHash != null) {
                this.nextTermsHash.abort();
            }
            throw throwable;
        }
    }

    void reset() {
        this.intPool.reset(false, false);
        this.bytePool.reset(false, false);
    }

    void flush(Map<String, TermsHashPerField> object, SegmentWriteState segmentWriteState) throws IOException {
        if (this.nextTermsHash != null) {
            HashMap<String, TermsHashPerField> hashMap = new HashMap<String, TermsHashPerField>();
            for (Map.Entry entry : object.entrySet()) {
                hashMap.put((String)entry.getKey(), ((TermsHashPerField)entry.getValue()).nextPerField);
            }
            this.nextTermsHash.flush(hashMap, segmentWriteState);
        }
    }

    abstract TermsHashPerField addField(FieldInvertState var1, FieldInfo var2);

    void finishDocument() throws IOException {
        if (this.nextTermsHash != null) {
            this.nextTermsHash.finishDocument();
        }
    }

    void startDocument() throws IOException {
        if (this.nextTermsHash != null) {
            this.nextTermsHash.startDocument();
        }
    }
}

