/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.codecs.TermVectorsWriter;
import org.apache.lucene.index.ByteSliceReader;
import org.apache.lucene.index.DocumentsWriterPerThread;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.FieldInvertState;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.TermVectorsConsumerPerField;
import org.apache.lucene.index.TermsHash;
import org.apache.lucene.index.TermsHashPerField;
import org.apache.lucene.store.FlushInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.IOUtils;
import org.apache.lucene.util.RamUsageEstimator;

final class TermVectorsConsumer
extends TermsHash {
    TermVectorsWriter writer;
    final BytesRef flushTerm = new BytesRef();
    final DocumentsWriterPerThread docWriter;
    final ByteSliceReader vectorSliceReaderPos = new ByteSliceReader();
    final ByteSliceReader vectorSliceReaderOff = new ByteSliceReader();
    boolean hasVectors;
    int numVectorFields;
    int lastDocID;
    private TermVectorsConsumerPerField[] perFields = new TermVectorsConsumerPerField[1];

    public TermVectorsConsumer(DocumentsWriterPerThread documentsWriterPerThread) {
        super(documentsWriterPerThread, false, null);
        this.docWriter = documentsWriterPerThread;
    }

    @Override
    final void flush(Map<String, TermsHashPerField> map, SegmentWriteState segmentWriteState) throws IOException {
        if (this.writer != null) {
            int n2 = segmentWriteState.segmentInfo.maxDoc();
            assert (n2 > 0);
            try {
                this.fill(n2);
                assert (segmentWriteState.segmentInfo != null);
                this.writer.finish(segmentWriteState.fieldInfos, n2);
            }
            catch (Throwable throwable) {
                IOUtils.close(this.writer);
                this.writer = null;
                this.lastDocID = 0;
                this.hasVectors = false;
                throw throwable;
            }
            IOUtils.close(this.writer);
            this.writer = null;
            this.lastDocID = 0;
            this.hasVectors = false;
            return;
        }
    }

    final void fill(int n2) throws IOException {
        while (this.lastDocID < n2) {
            this.writer.startDocument(0);
            this.writer.finishDocument();
            ++this.lastDocID;
        }
    }

    private void initTermVectorsWriter() throws IOException {
        if (this.writer == null) {
            IOContext iOContext = new IOContext(new FlushInfo(this.docWriter.getNumDocsInRAM(), this.docWriter.bytesUsed()));
            this.writer = this.docWriter.codec.termVectorsFormat().vectorsWriter(this.docWriter.directory, this.docWriter.getSegmentInfo(), iOContext);
            this.lastDocID = 0;
        }
    }

    @Override
    final void finishDocument() throws IOException {
        if (!this.hasVectors) {
            return;
        }
        ArrayUtil.introSort((Comparable[])this.perFields, (int)0, (int)this.numVectorFields);
        this.initTermVectorsWriter();
        this.fill(this.docState.docID);
        this.writer.startDocument(this.numVectorFields);
        for (int i2 = 0; i2 < this.numVectorFields; ++i2) {
            this.perFields[i2].finishDocument();
        }
        this.writer.finishDocument();
        assert (this.lastDocID == this.docState.docID) : "lastDocID=" + this.lastDocID + " docState.docID=" + this.docState.docID;
        ++this.lastDocID;
        super.reset();
        this.resetFields();
    }

    @Override
    public final void abort() {
        block3: {
            this.hasVectors = false;
            try {
                super.abort();
                if (this.writer == null) break block3;
            }
            catch (Throwable throwable) {
                if (this.writer != null) {
                    IOUtils.closeWhileHandlingException(this.writer);
                    this.writer = null;
                }
                this.lastDocID = 0;
                this.reset();
                throw throwable;
            }
            IOUtils.closeWhileHandlingException(this.writer);
            this.writer = null;
        }
        this.lastDocID = 0;
        this.reset();
    }

    final void resetFields() {
        Arrays.fill(this.perFields, null);
        this.numVectorFields = 0;
    }

    @Override
    public final TermsHashPerField addField(FieldInvertState fieldInvertState, FieldInfo fieldInfo) {
        return new TermVectorsConsumerPerField(fieldInvertState, this, fieldInfo);
    }

    final void addFieldToFlush(TermVectorsConsumerPerField termVectorsConsumerPerField) {
        if (this.numVectorFields == this.perFields.length) {
            TermVectorsConsumerPerField[] termVectorsConsumerPerFieldArray = new TermVectorsConsumerPerField[ArrayUtil.oversize(this.numVectorFields + 1, RamUsageEstimator.NUM_BYTES_OBJECT_REF)];
            System.arraycopy(this.perFields, 0, termVectorsConsumerPerFieldArray, 0, this.numVectorFields);
            this.perFields = termVectorsConsumerPerFieldArray;
        }
        this.perFields[this.numVectorFields++] = termVectorsConsumerPerField;
    }

    @Override
    final void startDocument() {
        this.resetFields();
        this.numVectorFields = 0;
    }
}

