/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import org.apache.lucene.index.IndexReaderContext;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.index.Terms;
import org.apache.lucene.index.TermsEnum;
import org.apache.lucene.index.q;
import org.apache.lucene.util.BytesRef;

public final class TermContext {
    public final IndexReaderContext topReaderContext;
    private final q[] states;
    private int docFreq;
    private long totalTermFreq;

    public TermContext(IndexReaderContext indexReaderContext) {
        assert (indexReaderContext != null && indexReaderContext.isTopLevel);
        this.topReaderContext = indexReaderContext;
        this.docFreq = 0;
        this.totalTermFreq = 0L;
        int n2 = indexReaderContext.leaves() == null ? 1 : indexReaderContext.leaves().size();
        this.states = new q[n2];
    }

    public TermContext(IndexReaderContext indexReaderContext, q q2, int n2, int n3, long l2) {
        this(indexReaderContext);
        this.register(q2, n2, n3, l2);
    }

    public static TermContext build(IndexReaderContext object, Term comparable) throws IOException {
        assert (object != null && ((IndexReaderContext)object).isTopLevel);
        String string = comparable.field();
        comparable = comparable.bytes();
        TermContext termContext = new TermContext((IndexReaderContext)object);
        for (LeafReaderContext leafReaderContext : ((IndexReaderContext)object).leaves()) {
            Object object2 = leafReaderContext.reader().terms(string);
            if (object2 == null || !((TermsEnum)(object2 = ((Terms)object2).iterator())).seekExact((BytesRef)comparable)) continue;
            q q2 = ((TermsEnum)object2).termState();
            termContext.register(q2, leafReaderContext.ord, ((TermsEnum)object2).docFreq(), ((TermsEnum)object2).totalTermFreq());
        }
        return termContext;
    }

    public final void register(q q2, int n2, int n3, long l2) {
        this.register(q2, n2);
        this.accumulateStatistics(n3, l2);
    }

    public final void register(q q2, int n2) {
        assert (q2 != null) : "state must not be null";
        assert (n2 >= 0 && n2 < this.states.length);
        assert (this.states[n2] == null) : "state for ord: " + n2 + " already registered";
        this.states[n2] = q2;
    }

    public final void accumulateStatistics(int n2, long l2) {
        this.docFreq += n2;
        if (this.totalTermFreq >= 0L && l2 >= 0L) {
            this.totalTermFreq += l2;
            return;
        }
        this.totalTermFreq = -1L;
    }

    public final q get(int n2) {
        assert (n2 >= 0 && n2 < this.states.length);
        return this.states[n2];
    }

    public final int docFreq() {
        return this.docFreq;
    }

    public final long totalTermFreq() {
        return this.totalTermFreq;
    }

    public final boolean hasOnlyRealTerms() {
        q[] qArray = this.states;
        int n2 = this.states.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            q q2 = qArray[i2];
            if (q2 == null || q2.isRealTerm()) continue;
            return false;
        }
        return true;
    }

    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("TermContext\n");
        q[] qArray = this.states;
        int n2 = this.states.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            q q2 = qArray[i2];
            stringBuilder.append("  state=");
            stringBuilder.append(q2.toString());
            stringBuilder.append('\n');
        }
        return stringBuilder.toString();
    }
}

