/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.LeafReader;
import org.apache.lucene.index.ReadersAndUpdates;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.apache.lucene.index.SegmentReader;
import org.apache.lucene.index.g;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.a;
import org.apache.lucene.store.c;
import org.apache.lucene.util.IOUtils;

final class StandardDirectoryReader
extends DirectoryReader {
    final IndexWriter writer;
    final SegmentInfos segmentInfos;
    private final boolean applyAllDeletes;

    StandardDirectoryReader(c c2, LeafReader[] leafReaderArray, IndexWriter indexWriter, SegmentInfos segmentInfos, boolean bl) throws IOException {
        super(c2, leafReaderArray);
        this.writer = indexWriter;
        this.segmentInfos = segmentInfos;
        this.applyAllDeletes = bl;
    }

    static DirectoryReader open(IndexWriter indexWriter, SegmentInfos object, boolean bl) throws IOException {
        int n2 = ((SegmentInfos)object).size();
        ArrayList<SegmentReader> arrayList = new ArrayList<SegmentReader>();
        c c2 = indexWriter.getDirectory();
        SegmentInfos segmentInfos = ((SegmentInfos)object).clone();
        int n3 = 0;
        boolean bl2 = false;
        try {
            Object object2;
            for (int i2 = 0; i2 < n2; ++i2) {
                object2 = ((SegmentInfos)object).info(i2);
                assert (((SegmentCommitInfo)object2).info.dir == c2);
                object2 = indexWriter.readerPool.get((SegmentCommitInfo)object2, true);
                try {
                    SegmentReader segmentReader = ((ReadersAndUpdates)object2).getReadOnlyClone(IOContext.READ);
                    if (segmentReader.numDocs() > 0 || indexWriter.getKeepFullyDeletedSegments()) {
                        arrayList.add(segmentReader);
                        ++n3;
                        continue;
                    }
                    segmentReader.decRef();
                    segmentInfos.remove(n3);
                    continue;
                }
                finally {
                    indexWriter.readerPool.release((ReadersAndUpdates)object2);
                }
            }
            indexWriter.incRefDeleter(segmentInfos);
            StandardDirectoryReader standardDirectoryReader = new StandardDirectoryReader(c2, arrayList.toArray(new SegmentReader[arrayList.size()]), indexWriter, segmentInfos, bl);
            bl2 = true;
            object2 = standardDirectoryReader;
            return object2;
        }
        catch (Throwable throwable) {
            if (!bl2) {
                for (SegmentReader segmentReader : arrayList) {
                    try {
                        segmentReader.decRef();
                    }
                    catch (Throwable throwable2) {}
                }
            }
            throw throwable;
        }
    }

    private static DirectoryReader open(c c2, SegmentInfos segmentInfos, List<? extends LeafReader> list) throws IOException {
        Object object;
        int n2;
        HashMap<String, Integer> hashMap = new HashMap<String, Integer>();
        if (list != null) {
            n2 = list.size();
            for (int i2 = 0; i2 < n2; ++i2) {
                object = (SegmentReader)list.get(i2);
                hashMap.put(((SegmentReader)object).getSegmentName(), i2);
            }
        }
        LeafReader[] leafReaderArray = new SegmentReader[segmentInfos.size()];
        for (n2 = segmentInfos.size() - 1; n2 >= 0; --n2) {
            object = segmentInfos.info(n2);
            Object object2 = (Integer)hashMap.get(((SegmentCommitInfo)object).info.name);
            object2 = object2 == null ? null : (SegmentReader)list.get((Integer)object2);
            try {
                boolean bl;
                if (object2 == null || ((SegmentCommitInfo)object).info.getUseCompoundFile() != ((SegmentReader)object2).getSegmentInfo().info.getUseCompoundFile()) {
                    leafReaderArray[n2] = object = new SegmentReader((SegmentCommitInfo)object, IOContext.READ);
                    continue;
                }
                if (((SegmentReader)object2).getSegmentInfo().getDelGen() == ((SegmentCommitInfo)object).getDelGen() && ((SegmentReader)object2).getSegmentInfo().getFieldInfosGen() == ((SegmentCommitInfo)object).getFieldInfosGen()) {
                    ((IndexReader)object2).incRef();
                    leafReaderArray[n2] = object2;
                    continue;
                }
                assert (((SegmentCommitInfo)object).info.dir == ((SegmentReader)object2).getSegmentInfo().info.dir);
                boolean bl2 = ((SegmentCommitInfo)object).info.maxDoc() != ((SegmentReader)object2).getSegmentInfo().info.maxDoc();
                boolean bl3 = !((SegmentCommitInfo)object).hasDeletions() && !((SegmentCommitInfo)object).hasFieldUpdates();
                boolean bl4 = bl = ((SegmentCommitInfo)object).getDelGen() == -1L && ((SegmentReader)object2).getSegmentInfo().getDelGen() != -1L;
                if (bl2 || bl3 || bl) {
                    throw new IllegalStateException("same segment " + ((SegmentCommitInfo)object).info.name + " has invalid changes; likely you are re-opening a reader after illegally removing index files yourself and building a new index in their place.  Use IndexWriter.deleteAll or OpenMode.CREATE instead");
                }
                if (((SegmentReader)object2).getSegmentInfo().getDelGen() == ((SegmentCommitInfo)object).getDelGen()) {
                    leafReaderArray[n2] = new SegmentReader((SegmentCommitInfo)object, (SegmentReader)object2, ((SegmentReader)object2).getLiveDocs(), ((SegmentReader)object2).numDocs());
                    continue;
                }
                leafReaderArray[n2] = new SegmentReader((SegmentCommitInfo)object, (SegmentReader)object2);
                continue;
            }
            catch (Throwable throwable) {
                StandardDirectoryReader.decRefWhileHandlingException((SegmentReader[])leafReaderArray);
                throw throwable;
            }
        }
        return new StandardDirectoryReader(c2, leafReaderArray, null, segmentInfos, false);
    }

    private static void decRefWhileHandlingException(SegmentReader[] segmentReaderArray) {
        for (SegmentReader segmentReader : segmentReaderArray) {
            if (segmentReader == null) continue;
            try {
                segmentReader.decRef();
            }
            catch (Throwable throwable) {}
        }
    }

    @Override
    public final String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(this.getClass().getSimpleName());
        stringBuilder.append('(');
        String string = this.segmentInfos.getSegmentsFileName();
        if (string != null) {
            stringBuilder.append(string).append(":").append(this.segmentInfos.getVersion());
        }
        if (this.writer != null) {
            stringBuilder.append(":nrt");
        }
        for (LeafReader leafReader : this.getSequentialSubReaders()) {
            stringBuilder.append(' ');
            stringBuilder.append(leafReader);
        }
        stringBuilder.append(')');
        return stringBuilder.toString();
    }

    @Override
    protected final DirectoryReader doOpenIfChanged() throws IOException {
        return this.doOpenIfChanged((g)null);
    }

    @Override
    protected final DirectoryReader doOpenIfChanged(g g2) throws IOException {
        this.ensureOpen();
        if (this.writer != null) {
            return this.doOpenFromWriter(g2);
        }
        return this.doOpenNoWriter(g2);
    }

    private DirectoryReader doOpenFromWriter(g object) throws IOException {
        if (object != null) {
            return this.doOpenFromCommit((g)object);
        }
        if (this.writer.nrtIsCurrent(this.segmentInfos)) {
            return null;
        }
        object = this.writer.getReader(this.applyAllDeletes);
        if (((DirectoryReader)object).getVersion() == this.segmentInfos.getVersion()) {
            ((IndexReader)object).decRef();
            return null;
        }
        return object;
    }

    private DirectoryReader doOpenNoWriter(g g2) throws IOException {
        if (g2 == null) {
            if (this.isCurrent()) {
                return null;
            }
        } else {
            if (this.directory != g2.getDirectory()) {
                throw new IOException("the specified commit does not match the specified Directory");
            }
            if (this.segmentInfos != null && g2.getSegmentsFileName().equals(this.segmentInfos.getSegmentsFileName())) {
                return null;
            }
        }
        return this.doOpenFromCommit(g2);
    }

    private DirectoryReader doOpenFromCommit(g g2) throws IOException {
        return (DirectoryReader)new SegmentInfos.FindSegmentsFile<DirectoryReader>(this.directory){

            @Override
            protected DirectoryReader doBody(String object) throws IOException {
                object = SegmentInfos.readCommit(this.directory, (String)object);
                return StandardDirectoryReader.this.doOpenIfChanged((SegmentInfos)object);
            }
        }.run(g2);
    }

    final DirectoryReader doOpenIfChanged(SegmentInfos segmentInfos) throws IOException {
        return StandardDirectoryReader.open(this.directory, segmentInfos, this.getSequentialSubReaders());
    }

    @Override
    public final long getVersion() {
        this.ensureOpen();
        return this.segmentInfos.getVersion();
    }

    public final boolean isCurrent() throws IOException {
        this.ensureOpen();
        if (this.writer == null || this.writer.isClosed()) {
            return SegmentInfos.readLatestCommit(this.directory).getVersion() == this.segmentInfos.getVersion();
        }
        return this.writer.nrtIsCurrent(this.segmentInfos);
    }

    @Override
    protected final void doClose() throws IOException {
        Throwable throwable = null;
        for (LeafReader leafReader : this.getSequentialSubReaders()) {
            try {
                leafReader.decRef();
            }
            catch (Throwable throwable2) {
                if (throwable != null) continue;
                throwable = throwable2;
            }
        }
        if (this.writer != null) {
            try {
                this.writer.decRefDeleter(this.segmentInfos);
            }
            catch (a a2) {}
        }
        IOUtils.reThrow(throwable);
    }
}

