/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import java.io.IOException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.NoSuchElementException;
import org.apache.lucene.codecs.DocValuesConsumer;
import org.apache.lucene.index.FieldInfo;
import org.apache.lucene.index.SegmentWriteState;
import org.apache.lucene.index.c;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.ByteBlockPool;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefHash;
import org.apache.lucene.util.Counter;
import org.apache.lucene.util.packed.PackedLongValues;

class SortedSetDocValuesWriter
extends c {
    final BytesRefHash hash;
    private PackedLongValues.Builder pending;
    private PackedLongValues.Builder pendingCounts;
    private final Counter iwBytesUsed;
    private long bytesUsed;
    private final FieldInfo fieldInfo;
    private int currentDoc;
    private int[] currentValues = new int[8];
    private int currentUpto = 0;
    private int maxCount = 0;

    public SortedSetDocValuesWriter(FieldInfo fieldInfo, Counter counter) {
        this.fieldInfo = fieldInfo;
        this.iwBytesUsed = counter;
        this.hash = new BytesRefHash(new ByteBlockPool(new ByteBlockPool.DirectTrackingAllocator(counter)), 16, new BytesRefHash.DirectBytesStartArray(16, counter));
        this.pending = PackedLongValues.packedBuilder(0.0f);
        this.pendingCounts = PackedLongValues.deltaPackedBuilder(0.0f);
        this.bytesUsed = this.pending.ramBytesUsed() + this.pendingCounts.ramBytesUsed();
        counter.addAndGet(this.bytesUsed);
    }

    public void addValue(int n2, BytesRef bytesRef) {
        if (bytesRef == null) {
            throw new IllegalArgumentException("field \"" + this.fieldInfo.name + "\": null value not allowed");
        }
        if (bytesRef.length > 32766) {
            throw new IllegalArgumentException("DocValuesField \"" + this.fieldInfo.name + "\" is too large, must be <= 32766");
        }
        if (n2 != this.currentDoc) {
            this.finishCurrentDoc();
        }
        while (this.currentDoc < n2) {
            this.pendingCounts.add(0L);
            ++this.currentDoc;
        }
        this.addOneValue(bytesRef);
        this.updateBytesUsed();
    }

    private void finishCurrentDoc() {
        Arrays.sort(this.currentValues, 0, this.currentUpto);
        int n2 = -1;
        int n3 = 0;
        for (int i2 = 0; i2 < this.currentUpto; ++i2) {
            int n4 = this.currentValues[i2];
            if (n4 != n2) {
                this.pending.add(n4);
                ++n3;
            }
            n2 = n4;
        }
        this.pendingCounts.add(n3);
        this.maxCount = Math.max(this.maxCount, n3);
        this.currentUpto = 0;
        ++this.currentDoc;
    }

    @Override
    public void finish(int n2) {
        this.finishCurrentDoc();
        for (int i2 = this.currentDoc; i2 < n2; ++i2) {
            this.pendingCounts.add(0L);
        }
    }

    private void addOneValue(BytesRef bytesRef) {
        int n2 = this.hash.add(bytesRef);
        if (n2 < 0) {
            n2 = -n2 - 1;
        } else {
            this.iwBytesUsed.addAndGet(8L);
        }
        if (this.currentUpto == this.currentValues.length) {
            this.currentValues = ArrayUtil.grow(this.currentValues, this.currentValues.length + 1);
            this.iwBytesUsed.addAndGet(this.currentValues.length - this.currentUpto << 1 << 2);
        }
        this.currentValues[this.currentUpto] = n2;
        ++this.currentUpto;
    }

    private void updateBytesUsed() {
        long l2 = this.pending.ramBytesUsed() + this.pendingCounts.ramBytesUsed();
        this.iwBytesUsed.addAndGet(l2 - this.bytesUsed);
        this.bytesUsed = l2;
    }

    @Override
    public void flush(SegmentWriteState segmentWriteState, DocValuesConsumer docValuesConsumer) throws IOException {
        final int n2 = segmentWriteState.segmentInfo.maxDoc();
        final int n3 = this.maxCount;
        assert (this.pendingCounts.size() == (long)n2);
        final int n4 = this.hash.size();
        final PackedLongValues packedLongValues = this.pending.build();
        final PackedLongValues packedLongValues2 = this.pendingCounts.build();
        final int[] nArray = this.hash.sort(BytesRef.getUTF8SortedAsUnicodeComparator());
        final int[] nArray2 = new int[n4];
        for (int i2 = 0; i2 < n4; ++i2) {
            nArray2[nArray[i2]] = i2;
        }
        docValuesConsumer.addSortedSetField(this.fieldInfo, new Iterable<BytesRef>(){

            @Override
            public Iterator<BytesRef> iterator() {
                return new ValuesIterator(nArray, n4, SortedSetDocValuesWriter.this.hash);
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new OrdCountIterator(n2, packedLongValues2);
            }
        }, new Iterable<Number>(){

            @Override
            public Iterator<Number> iterator() {
                return new OrdsIterator(nArray2, n3, packedLongValues, packedLongValues2);
            }
        });
    }

    private static class OrdCountIterator
    implements Iterator<Number> {
        final PackedLongValues.Iterator iter;
        final int maxDoc;
        int docUpto;

        OrdCountIterator(int n2, PackedLongValues packedLongValues) {
            this.maxDoc = n2;
            assert (packedLongValues.size() == (long)n2);
            this.iter = packedLongValues.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.docUpto < this.maxDoc;
        }

        @Override
        public Number next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            ++this.docUpto;
            return this.iter.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class OrdsIterator
    implements Iterator<Number> {
        final PackedLongValues.Iterator iter;
        final PackedLongValues.Iterator counts;
        final int[] ordMap;
        final long numOrds;
        long ordUpto;
        final int[] currentDoc;
        int currentUpto;
        int currentLength;

        OrdsIterator(int[] nArray, int n2, PackedLongValues packedLongValues, PackedLongValues packedLongValues2) {
            this.currentDoc = new int[n2];
            this.ordMap = nArray;
            this.numOrds = packedLongValues.size();
            this.iter = packedLongValues.iterator();
            this.counts = packedLongValues2.iterator();
        }

        @Override
        public boolean hasNext() {
            return this.ordUpto < this.numOrds;
        }

        @Override
        public Number next() {
            int n2;
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            while (this.currentUpto == this.currentLength) {
                this.currentUpto = 0;
                this.currentLength = (int)this.counts.next();
                for (n2 = 0; n2 < this.currentLength; ++n2) {
                    this.currentDoc[n2] = this.ordMap[(int)this.iter.next()];
                }
                Arrays.sort(this.currentDoc, 0, this.currentLength);
            }
            n2 = this.currentDoc[this.currentUpto];
            ++this.currentUpto;
            ++this.ordUpto;
            return n2;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class ValuesIterator
    implements Iterator<BytesRef> {
        final int[] sortedValues;
        final BytesRefHash hash;
        final BytesRef scratch = new BytesRef();
        final int valueCount;
        int ordUpto;

        ValuesIterator(int[] nArray, int n2, BytesRefHash bytesRefHash) {
            this.sortedValues = nArray;
            this.valueCount = n2;
            this.hash = bytesRefHash;
        }

        @Override
        public boolean hasNext() {
            return this.ordUpto < this.valueCount;
        }

        @Override
        public BytesRef next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            this.hash.get(this.sortedValues[this.ordUpto], this.scratch);
            ++this.ordUpto;
            return this.scratch;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

