/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.index;

import org.apache.lucene.index.BufferedUpdates;
import org.apache.lucene.index.FieldInfos;
import org.apache.lucene.index.SegmentInfo;
import org.apache.lucene.store.IOContext;
import org.apache.lucene.store.c;
import org.apache.lucene.util.InfoStream;
import org.apache.lucene.util.i;

public class SegmentWriteState {
    public final InfoStream infoStream;
    public final c directory;
    public final SegmentInfo segmentInfo;
    public final FieldInfos fieldInfos;
    public int delCountOnFlush;
    public final BufferedUpdates segUpdates;
    public i liveDocs;
    public final String segmentSuffix;
    public final IOContext context;

    public SegmentWriteState(InfoStream infoStream, c c2, SegmentInfo segmentInfo, FieldInfos fieldInfos, BufferedUpdates bufferedUpdates, IOContext iOContext) {
        this(infoStream, c2, segmentInfo, fieldInfos, bufferedUpdates, iOContext, "");
    }

    public SegmentWriteState(InfoStream infoStream, c c2, SegmentInfo segmentInfo, FieldInfos fieldInfos, BufferedUpdates bufferedUpdates, IOContext iOContext, String string) {
        this.infoStream = infoStream;
        this.segUpdates = bufferedUpdates;
        this.directory = c2;
        this.segmentInfo = segmentInfo;
        this.fieldInfos = fieldInfos;
        assert (this.assertSegmentSuffix(string));
        this.segmentSuffix = string;
        this.context = iOContext;
    }

    public SegmentWriteState(SegmentWriteState segmentWriteState, String string) {
        this.infoStream = segmentWriteState.infoStream;
        this.directory = segmentWriteState.directory;
        this.segmentInfo = segmentWriteState.segmentInfo;
        this.fieldInfos = segmentWriteState.fieldInfos;
        this.context = segmentWriteState.context;
        this.segmentSuffix = string;
        this.segUpdates = segmentWriteState.segUpdates;
        this.delCountOnFlush = segmentWriteState.delCountOnFlush;
        this.liveDocs = segmentWriteState.liveDocs;
    }

    private boolean assertSegmentSuffix(String string) {
        assert (string != null);
        if (!string.isEmpty()) {
            int n2 = string.split("_").length;
            if (n2 == 2) {
                return true;
            }
            if (n2 == 1) {
                Long.parseLong(string, 36);
                return true;
            }
            return false;
        }
        return true;
    }
}

